/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;

final class DecodeTask {
    private final byte[] mImage;
    private final Point mImageSize;
    private final Point mPreviewSize;
    private final Point mViewSize;
    private final Rect mViewFrameRect;
    private final int mOrientation;
    private final boolean mReverseHorizontal;

    public DecodeTask(@NonNull byte[] image, @NonNull Point imageSize, @NonNull Point previewSize, @NonNull Point viewSize, @NonNull Rect viewFrameRect, int orientation, boolean reverseHorizontal) {
        this.mImage = image;
        this.mImageSize = imageSize;
        this.mPreviewSize = previewSize;
        this.mViewSize = viewSize;
        this.mViewFrameRect = viewFrameRect;
        this.mOrientation = orientation;
        this.mReverseHorizontal = reverseHorizontal;
    }

    @Nullable
    public Result decode(@NonNull MultiFormatReader reader) throws ReaderException {
        int height;
        int width;
        byte[] image;
        int imageWidth = this.mImageSize.getX();
        int imageHeight = this.mImageSize.getY();
        if (this.mOrientation == 0) {
            image = this.mImage;
            width = imageWidth;
            height = imageHeight;
        } else {
            image = Utils.rotateNV21(this.mImage, imageWidth, imageHeight, this.mOrientation);
            if (this.mOrientation == 90 || this.mOrientation == 270) {
                width = imageHeight;
                height = imageWidth;
            } else {
                width = imageWidth;
                height = imageHeight;
            }
        }
        Rect frameRect = Utils.getImageFrameRect(width, height, this.mViewFrameRect, this.mPreviewSize, this.mViewSize);
        int frameWidth = frameRect.getWidth();
        int frameHeight = frameRect.getHeight();
        if (frameWidth > 0 && frameHeight > 0) {
            return reader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new PlanarYUVLuminanceSource(image, width, height, frameRect.getLeft(), frameRect.getTop(), frameWidth, frameHeight, this.mReverseHorizontal))));
        }
        return null;
    }
}

