/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.graphics.Matrix;
import androidx.annotation.NonNull;

final class Rect {
    private final int mLeft;
    private final int mTop;
    private final int mRight;
    private final int mBottom;

    public Rect(int left, int top, int right, int bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRight() {
        return this.mRight;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public int getWidth() {
        return this.mRight - this.mLeft;
    }

    public int getHeight() {
        return this.mBottom - this.mTop;
    }

    public boolean isPointInside(int x, int y) {
        return this.mLeft < x && this.mTop < y && this.mRight > x && this.mBottom > y;
    }

    @NonNull
    public Rect sort() {
        int temp;
        int left = this.mLeft;
        int top = this.mTop;
        int right = this.mRight;
        int bottom = this.mBottom;
        if (left <= right && top <= bottom) {
            return this;
        }
        if (left > right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top > bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        return new Rect(left, top, right, bottom);
    }

    @NonNull
    public Rect bound(int left, int top, int right, int bottom) {
        int l = this.mLeft;
        int t = this.mTop;
        int r = this.mRight;
        int b = this.mBottom;
        if (l >= left && t >= top && r <= right && b <= bottom) {
            return this;
        }
        return new Rect(Math.max(l, left), Math.max(t, top), Math.min(r, right), Math.min(b, bottom));
    }

    @NonNull
    public Rect rotate(float angle, float x, float y) {
        int temp;
        Matrix matrix = new Matrix();
        float[] rect = new float[]{this.mLeft, this.mTop, this.mRight, this.mBottom};
        matrix.postRotate(angle, x, y);
        matrix.mapPoints(rect);
        int left = (int)rect[0];
        int top = (int)rect[1];
        int right = (int)rect[2];
        int bottom = (int)rect[3];
        if (left > right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top > bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        return new Rect(left, top, right, bottom);
    }

    @NonNull
    public Rect fitIn(@NonNull Rect area) {
        int left = this.mLeft;
        int top = this.mTop;
        int right = this.mRight;
        int bottom = this.mBottom;
        int width = this.getWidth();
        int height = this.getHeight();
        int areaLeft = area.mLeft;
        int areaTop = area.mTop;
        int areaRight = area.mRight;
        int areaBottom = area.mBottom;
        int areaWidth = area.getWidth();
        int areaHeight = area.getHeight();
        if (left >= areaLeft && top >= areaTop && right <= areaRight && bottom <= areaBottom) {
            return this;
        }
        int fitWidth = Math.min(width, areaWidth);
        int fitHeight = Math.min(height, areaHeight);
        if (left < areaLeft) {
            left = areaLeft;
            right = left + fitWidth;
        } else if (right > areaRight) {
            right = areaRight;
            left = right - fitWidth;
        }
        if (top < areaTop) {
            top = areaTop;
            bottom = top + fitHeight;
        } else if (bottom > areaBottom) {
            bottom = areaBottom;
            top = bottom - fitHeight;
        }
        return new Rect(left, top, right, bottom);
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.mLeft + this.mTop) + this.mRight) + this.mBottom;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rect) {
            Rect other = (Rect)obj;
            return this.mLeft == other.mLeft && this.mTop == other.mTop && this.mRight == other.mRight && this.mBottom == other.mBottom;
        }
        return false;
    }

    @NonNull
    public String toString() {
        return "[(" + this.mLeft + "; " + this.mTop + ") - (" + this.mRight + "; " + this.mBottom + ")]";
    }
}

