/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.codescanner.CodeScanner;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class BarcodeUtils {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 90;
    public static final int ROTATION_180 = 180;
    public static final int ROTATION_270 = 270;

    private BarcodeUtils() {
    }

    @Nullable
    public static Result decodeBitmap(@NonNull Bitmap bitmap) {
        return BarcodeUtils.decodeBitmap(bitmap, null);
    }

    @Nullable
    public static Result decodeBitmap(@NonNull Bitmap bitmap, @Nullable Map<DecodeHintType, ?> hints) {
        Objects.requireNonNull(bitmap);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        return BarcodeUtils.decodeRgb(pixels, width, height, hints);
    }

    @Nullable
    public static Result decodeRgb(@NonNull int[] pixels, int width, int height) {
        return BarcodeUtils.decodeRgb(pixels, width, height, null);
    }

    @Nullable
    public static Result decodeRgb(@NonNull int[] pixels, int width, int height, @Nullable Map<DecodeHintType, ?> hints) {
        Objects.requireNonNull(pixels);
        MultiFormatReader reader = BarcodeUtils.createReader(hints);
        try {
            return Utils.decodeLuminanceSource(reader, (LuminanceSource)new RGBLuminanceSource(width, height, pixels));
        }
        catch (ReaderException e) {
            return null;
        }
    }

    @Nullable
    public static Result decodeYuv(@NonNull byte[] pixels, int width, int height) {
        return BarcodeUtils.decodeYuv(pixels, width, height, 0, false, null);
    }

    @Nullable
    public static Result decodeYuv(@NonNull byte[] pixels, int width, int height, int rotation, boolean reverseHorizontal, @Nullable Map<DecodeHintType, ?> hints) {
        int rotatedHeight;
        int rotatedWidth;
        Objects.requireNonNull(pixels);
        byte[] rotatedPixels = Utils.rotateYuv(pixels, width, height, rotation);
        if (rotation == 90 || rotation == 270) {
            rotatedWidth = height;
            rotatedHeight = width;
        } else {
            rotatedWidth = width;
            rotatedHeight = height;
        }
        MultiFormatReader reader = BarcodeUtils.createReader(hints);
        try {
            return Utils.decodeLuminanceSource(reader, (LuminanceSource)new PlanarYUVLuminanceSource(rotatedPixels, rotatedWidth, rotatedHeight, 0, 0, rotatedWidth, rotatedHeight, reverseHorizontal));
        }
        catch (ReaderException e) {
            return null;
        }
    }

    @Nullable
    public static BitMatrix encodeBitMatrix(@NonNull String content, @NonNull BarcodeFormat format, int width, int height) {
        return BarcodeUtils.encodeBitMatrix(content, format, width, height, null);
    }

    @Nullable
    public static BitMatrix encodeBitMatrix(@NonNull String content, @NonNull BarcodeFormat format, int width, int height, @Nullable Map<EncodeHintType, ?> hints) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(format);
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            if (hints != null) {
                return writer.encode(content, format, width, height, hints);
            }
            return writer.encode(content, format, width, height);
        }
        catch (WriterException e) {
            return null;
        }
    }

    @Nullable
    public static Bitmap encodeBitmap(@NonNull String content, @NonNull BarcodeFormat format, int width, int height) {
        return BarcodeUtils.encodeBitmap(content, format, width, height, null);
    }

    @Nullable
    public static Bitmap encodeBitmap(@NonNull String content, @NonNull BarcodeFormat format, int width, int height, @Nullable Map<EncodeHintType, ?> hints) {
        BitMatrix matrix = BarcodeUtils.encodeBitMatrix(content, format, width, height, hints);
        if (matrix != null) {
            return BarcodeUtils.createBitmap(matrix);
        }
        return null;
    }

    @NonNull
    public static Bitmap createBitmap(@NonNull BitMatrix matrix) {
        Objects.requireNonNull(matrix);
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int length = width * height;
        int[] pixels = new int[length];
        for (int i = 0; i < length; ++i) {
            pixels[i] = matrix.get(i % width, i / height) ? -16777216 : -1;
        }
        return Bitmap.createBitmap((int[])pixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @NonNull
    private static MultiFormatReader createReader(@Nullable Map<DecodeHintType, ?> hints) {
        MultiFormatReader reader = new MultiFormatReader();
        if (hints != null) {
            reader.setHints(hints);
        } else {
            reader.setHints(Collections.singletonMap(DecodeHintType.POSSIBLE_FORMATS, CodeScanner.ALL_FORMATS));
        }
        return reader;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Rotation {
    }
}

