/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.DecodeTask;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class Decoder {
    private final BlockingQueue<DecodeTask> mDecodeQueue = new LinkedBlockingQueue<DecodeTask>();
    private final MultiFormatReader mReader;
    private final DecoderThread mDecoderThread;
    private final StateListener mStateListener;
    private final Map<DecodeHintType, Object> mHints;
    private volatile DecodeCallback mCallback;
    private volatile boolean mProcessing;

    public Decoder(@NonNull StateListener stateListener, @NonNull List<BarcodeFormat> formats, @Nullable DecodeCallback callback) {
        this.mStateListener = stateListener;
        this.mReader = new MultiFormatReader();
        this.mDecoderThread = new DecoderThread();
        this.mHints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
        this.mCallback = callback;
    }

    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
    }

    public void setCallback(@Nullable DecodeCallback callback) {
        this.mCallback = callback;
    }

    public void decode(@NonNull DecodeTask task) {
        this.mDecodeQueue.add(task);
    }

    public void start() {
        this.mDecoderThread.start();
    }

    public void shutdown() {
        this.mDecoderThread.interrupt();
        this.mDecodeQueue.clear();
    }

    public boolean isProcessing() {
        return this.mProcessing;
    }

    public static enum State {
        IDLE,
        DECODING,
        DECODED;

    }

    public static interface StateListener {
        public boolean onStateChanged(@NonNull State var1);
    }

    private final class DecoderThread
    extends Thread {
        public DecoderThread() {
            super("Code scanner decode thread");
            if (this.getPriority() != 1) {
                this.setPriority(1);
            }
            if (this.isDaemon()) {
                this.setDaemon(false);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Decoder.this.mStateListener.onStateChanged(State.IDLE);
                    Result result = null;
                    try {
                        DecodeTask task = (DecodeTask)Decoder.this.mDecodeQueue.take();
                        Decoder.this.mProcessing = true;
                        Decoder.this.mStateListener.onStateChanged(State.DECODING);
                        result = task.decode(Decoder.this.mReader);
                    }
                    catch (ReaderException callback) {}
                    continue;
                    finally {
                        if (result != null) {
                            Decoder.this.mDecodeQueue.clear();
                            if (Decoder.this.mStateListener.onStateChanged(State.DECODED) && (callback = Decoder.this.mCallback) != null) {
                                callback.onDecoded(result);
                            }
                        }
                        Decoder.this.mProcessing = false;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

