/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.SurfaceHolder;
import android.view.View;
import com.budiyev.android.codescanner.AutoFocusMode;
import com.budiyev.android.codescanner.CodeScannerException;
import com.budiyev.android.codescanner.CodeScannerView;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.DecodeTask;
import com.budiyev.android.codescanner.Decoder;
import com.budiyev.android.codescanner.DecoderWrapper;
import com.budiyev.android.codescanner.ErrorCallback;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.ScanMode;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.android.camera.CameraConfigurationUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CodeScanner {
    public static final List<BarcodeFormat> ALL_FORMATS = Arrays.asList(BarcodeFormat.values());
    public static final List<BarcodeFormat> ONE_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION);
    public static final List<BarcodeFormat> TWO_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.AZTEC, BarcodeFormat.DATA_MATRIX, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE);
    private static final List<BarcodeFormat> DEFAULT_FORMATS = ALL_FORMATS;
    private static final ScanMode DEFAULT_SCAN_MODE = ScanMode.SINGLE;
    private static final AutoFocusMode DEFAULT_AUTO_FOCUS_MODE = AutoFocusMode.SAFE;
    private static final long DEFAULT_SAFE_AUTO_FOCUS_INTERVAL = 2000L;
    private static final int DEFAULT_CAMERA = -1;
    private static final boolean DEFAULT_AUTO_FOCUS_ENABLED = true;
    private static final boolean DEFAULT_FLASH_ENABLED = false;
    private static final int SAFE_AUTO_FOCUS_ATTEMPTS_THRESHOLD = 2;
    private final Lock mInitializeLock = new ReentrantLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final CodeScannerView mScannerView;
    private final SurfaceHolder mSurfaceHolder;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final Camera.PreviewCallback mPreviewCallback;
    private final Camera.AutoFocusCallback mSafeAutoFocusCallback;
    private final Runnable mSafeAutoFocusTask;
    private final Runnable mStopPreviewTask;
    private final DecoderStateListener mDecoderStateListener;
    private volatile List<BarcodeFormat> mFormats = DEFAULT_FORMATS;
    private volatile ScanMode mScanMode = DEFAULT_SCAN_MODE;
    private volatile AutoFocusMode mAutoFocusMode = DEFAULT_AUTO_FOCUS_MODE;
    private volatile DecodeCallback mDecodeCallback;
    private volatile ErrorCallback mErrorCallback;
    private volatile DecoderWrapper mDecoderWrapper;
    private volatile boolean mInitialization;
    private volatile boolean mInitialized;
    private volatile boolean mStoppingPreview;
    private volatile boolean mAutoFocusEnabled = true;
    private volatile boolean mFlashEnabled = false;
    private volatile long mSafeAutoFocusInterval = 2000L;
    private volatile int mCameraId = -1;
    private boolean mPreviewActive;
    private boolean mSafeAutoFocusing;
    private boolean mSafeAutoFocusTaskScheduled;
    private int mSafeAutoFocusAttemptsCount;

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view) {
        this.mContext = context;
        this.mScannerView = view;
        this.mSurfaceHolder = view.getPreviewView().getHolder();
        this.mMainThreadHandler = new Handler();
        this.mSurfaceCallback = new SurfaceCallback();
        this.mPreviewCallback = new PreviewCallback();
        this.mSafeAutoFocusCallback = new SafeAutoFocusCallback();
        this.mSafeAutoFocusTask = new SafeAutoFocusTask();
        this.mStopPreviewTask = new StopPreviewTask();
        this.mDecoderStateListener = new DecoderStateListener();
        this.mScannerView.setCodeScanner(this);
    }

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view, int cameraId) {
        this(context, view);
        this.mCameraId = cameraId;
    }

    @MainThread
    public void setCamera(int cameraId) {
        this.mInitializeLock.lock();
        try {
            if (this.mCameraId != cameraId) {
                this.mCameraId = cameraId;
                if (this.mInitialized) {
                    boolean previewActive = this.mPreviewActive;
                    this.releaseResources();
                    if (previewActive) {
                        this.initialize();
                    }
                }
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    @MainThread
    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mInitializeLock.lock();
        try {
            this.mFormats = formats;
            if (this.mInitialized) {
                this.mDecoderWrapper.getDecoder().setFormats(formats);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    @MainThread
    public void setFormats(BarcodeFormat ... formats) {
        this.setFormats(Arrays.asList(formats));
    }

    @MainThread
    public void setFormat(@NonNull BarcodeFormat format) {
        this.setFormats(Collections.singletonList(format));
    }

    public void setDecodeCallback(@Nullable DecodeCallback decodeCallback) {
        this.mInitializeLock.lock();
        try {
            this.mDecodeCallback = decodeCallback;
            if (this.mInitialized) {
                this.mDecoderWrapper.getDecoder().setCallback(decodeCallback);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public void setErrorCallback(@Nullable ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    public void setScanMode(@NonNull ScanMode scanMode) {
        this.mScanMode = scanMode;
    }

    @MainThread
    public void setAutoFocusEnabled(boolean autoFocusEnabled) {
        this.mInitializeLock.lock();
        try {
            boolean changed = this.mAutoFocusEnabled != autoFocusEnabled;
            this.mAutoFocusEnabled = autoFocusEnabled;
            this.mScannerView.setAutoFocusEnabled(autoFocusEnabled);
            if (this.mInitialized && this.mPreviewActive && changed && this.mDecoderWrapper.isAutoFocusSupported()) {
                this.setAutoFocusEnabledInternal(autoFocusEnabled);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.mAutoFocusEnabled;
    }

    @MainThread
    public void setAutoFocusMode(@NonNull AutoFocusMode autoFocusMode) {
        this.mInitializeLock.lock();
        try {
            this.mAutoFocusMode = autoFocusMode;
            if (this.mInitialized && this.mAutoFocusEnabled) {
                this.setAutoFocusEnabledInternal(true);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public void setAutoFocusInterval(long autoFocusInterval) {
        this.mSafeAutoFocusInterval = autoFocusInterval;
    }

    @MainThread
    public void setFlashEnabled(boolean flashEnabled) {
        this.mInitializeLock.lock();
        try {
            boolean changed = this.mFlashEnabled != flashEnabled;
            this.mFlashEnabled = flashEnabled;
            this.mScannerView.setFlashEnabled(flashEnabled);
            if (this.mInitialized && this.mPreviewActive && changed && this.mDecoderWrapper.isFlashSupported()) {
                this.setFlashEnabledInternal(flashEnabled);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public boolean isFlashEnabled() {
        return this.mFlashEnabled;
    }

    public boolean isPreviewActive() {
        return this.mPreviewActive;
    }

    @MainThread
    public void startPreview() {
        this.mInitializeLock.lock();
        try {
            if (!this.mInitialized && !this.mInitialization) {
                this.initialize();
                return;
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
        if (!this.mPreviewActive) {
            this.mSurfaceHolder.addCallback(this.mSurfaceCallback);
            this.startPreviewInternal(false);
        }
    }

    @MainThread
    public void stopPreview() {
        if (this.mInitialized && this.mPreviewActive) {
            this.mSurfaceHolder.removeCallback(this.mSurfaceCallback);
            this.stopPreviewInternal(false);
        }
    }

    @MainThread
    public void releaseResources() {
        if (this.mInitialized) {
            if (this.mPreviewActive) {
                this.stopPreview();
            }
            this.releaseResourcesInternal();
        }
    }

    private void initialize() {
        this.mInitialization = true;
        if (Utils.isLaidOut((View)this.mScannerView)) {
            this.initialize(this.mScannerView.getWidth(), this.mScannerView.getHeight());
        } else {
            this.mScannerView.setLayoutListener(new ScannerLayoutListener());
        }
    }

    private void initialize(int width, int height) {
        new InitializationThread(width, height).start();
    }

    private void startPreviewInternal(boolean internal) {
        try {
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            camera.setPreviewCallback(this.mPreviewCallback);
            camera.setPreviewDisplay(this.mSurfaceHolder);
            if (!internal && decoderWrapper.isFlashSupported() && this.mFlashEnabled) {
                this.setFlashEnabledInternal(true);
            }
            camera.startPreview();
            this.mStoppingPreview = false;
            this.mPreviewActive = true;
            this.mSafeAutoFocusing = false;
            this.mSafeAutoFocusAttemptsCount = 0;
            if (this.mAutoFocusMode == AutoFocusMode.SAFE) {
                this.scheduleSafeAutoFocusTask();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPreviewInternalSafe() {
        if (this.mInitialized && !this.mPreviewActive) {
            this.startPreviewInternal(true);
        }
    }

    private void stopPreviewInternal(boolean internal) {
        try {
            Camera.Parameters parameters;
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            if (!internal && decoderWrapper.isFlashSupported() && this.mFlashEnabled && (parameters = camera.getParameters()) != null && Utils.setFlashMode(parameters, "off")) {
                camera.setParameters(parameters);
            }
            camera.setPreviewCallback(null);
            camera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mStoppingPreview = false;
        this.mPreviewActive = false;
        this.mSafeAutoFocusing = false;
        this.mSafeAutoFocusAttemptsCount = 0;
    }

    private void stopPreviewInternalSafe() {
        if (this.mInitialized && this.mPreviewActive) {
            this.stopPreviewInternal(true);
        }
    }

    private void releaseResourcesInternal() {
        this.mInitialized = false;
        this.mInitialization = false;
        this.mStoppingPreview = false;
        this.mPreviewActive = false;
        this.mSafeAutoFocusing = false;
        DecoderWrapper decoderWrapper = this.mDecoderWrapper;
        if (decoderWrapper != null) {
            this.mDecoderWrapper = null;
            decoderWrapper.release();
        }
    }

    private void setFlashEnabledInternal(boolean flashEnabled) {
        try {
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                return;
            }
            boolean changed = flashEnabled ? Utils.setFlashMode(parameters, "torch") : Utils.setFlashMode(parameters, "off");
            if (changed) {
                CameraConfigurationUtils.setBestExposure((Camera.Parameters)parameters, (boolean)flashEnabled);
                camera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAutoFocusEnabledInternal(boolean autoFocusEnabled) {
        try {
            boolean changed;
            Camera camera = this.mDecoderWrapper.getCamera();
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                return;
            }
            AutoFocusMode autoFocusMode = this.mAutoFocusMode;
            if (autoFocusEnabled) {
                changed = Utils.setAutoFocusMode(parameters, autoFocusMode);
            } else {
                camera.cancelAutoFocus();
                changed = Utils.disableAutoFocus(parameters);
            }
            if (changed) {
                camera.setParameters(parameters);
            }
            if (autoFocusEnabled) {
                this.mSafeAutoFocusAttemptsCount = 0;
                this.mSafeAutoFocusing = false;
                if (autoFocusMode == AutoFocusMode.SAFE) {
                    this.scheduleSafeAutoFocusTask();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeAutoFocusCamera() {
        if (!this.mInitialized || !this.mPreviewActive) {
            return;
        }
        if (!this.mDecoderWrapper.isAutoFocusSupported() || !this.mAutoFocusEnabled) {
            return;
        }
        if (this.mSafeAutoFocusing && this.mSafeAutoFocusAttemptsCount < 2) {
            ++this.mSafeAutoFocusAttemptsCount;
        } else {
            try {
                Camera camera = this.mDecoderWrapper.getCamera();
                camera.cancelAutoFocus();
                camera.autoFocus(this.mSafeAutoFocusCallback);
                this.mSafeAutoFocusAttemptsCount = 0;
                this.mSafeAutoFocusing = true;
            }
            catch (Exception e) {
                this.mSafeAutoFocusing = false;
            }
        }
        this.scheduleSafeAutoFocusTask();
    }

    private void scheduleSafeAutoFocusTask() {
        if (this.mSafeAutoFocusTaskScheduled) {
            return;
        }
        this.mSafeAutoFocusTaskScheduled = true;
        this.mMainThreadHandler.postDelayed(this.mSafeAutoFocusTask, this.mSafeAutoFocusInterval);
    }

    boolean isAutoFocusSupportedOrUnknown() {
        DecoderWrapper wrapper = this.mDecoderWrapper;
        return wrapper == null || wrapper.isAutoFocusSupported();
    }

    boolean isFlashSupportedOrUnknown() {
        DecoderWrapper wrapper = this.mDecoderWrapper;
        return wrapper == null || wrapper.isFlashSupported();
    }

    @NonNull
    @MainThread
    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ List access$3500() {
        return DEFAULT_FORMATS;
    }

    static /* synthetic */ ScanMode access$3600() {
        return DEFAULT_SCAN_MODE;
    }

    static /* synthetic */ AutoFocusMode access$3700() {
        return DEFAULT_AUTO_FOCUS_MODE;
    }

    public static final class Builder {
        private int mCameraId = -1;
        private List<BarcodeFormat> mFormats = CodeScanner.access$3500();
        private DecodeCallback mDecodeCallback;
        private ErrorCallback mErrorCallback;
        private boolean mAutoFocusEnabled = true;
        private ScanMode mScanMode = CodeScanner.access$3600();
        private AutoFocusMode mAutoFocusMode = CodeScanner.access$3700();
        private long mAutoFocusInterval = 2000L;
        private boolean mFlashEnabled = false;

        private Builder() {
        }

        @NonNull
        @MainThread
        public Builder camera(int cameraId) {
            this.mCameraId = cameraId;
            return this;
        }

        @NonNull
        @MainThread
        public Builder formats(@NonNull List<BarcodeFormat> formats) {
            this.mFormats = formats;
            return this;
        }

        @NonNull
        @MainThread
        public Builder formats(BarcodeFormat ... formats) {
            this.mFormats = Arrays.asList(formats);
            return this;
        }

        @NonNull
        @MainThread
        public Builder format(@NonNull BarcodeFormat format) {
            this.mFormats = Collections.singletonList(format);
            return this;
        }

        @NonNull
        @MainThread
        public Builder onDecoded(@Nullable DecodeCallback callback) {
            this.mDecodeCallback = callback;
            return this;
        }

        @NonNull
        @MainThread
        public Builder onError(@Nullable ErrorCallback callback) {
            this.mErrorCallback = callback;
            return this;
        }

        @NonNull
        @MainThread
        public Builder scanMode(@NonNull ScanMode mode) {
            this.mScanMode = mode;
            return this;
        }

        @NonNull
        @MainThread
        public Builder autoFocus(boolean enabled) {
            this.mAutoFocusEnabled = enabled;
            return this;
        }

        @NonNull
        @MainThread
        public Builder autoFocusMode(@NonNull AutoFocusMode mode) {
            this.mAutoFocusMode = mode;
            return this;
        }

        @NonNull
        @MainThread
        public Builder autoFocusInterval(long interval) {
            this.mAutoFocusInterval = interval;
            return this;
        }

        @NonNull
        @MainThread
        public Builder flash(boolean enabled) {
            this.mFlashEnabled = enabled;
            return this;
        }

        @NonNull
        @MainThread
        public CodeScanner build(@NonNull Context context, @NonNull CodeScannerView view) {
            CodeScanner scanner = new CodeScanner(context, view);
            scanner.mCameraId = this.mCameraId;
            scanner.mFormats = this.mFormats;
            scanner.mDecodeCallback = this.mDecodeCallback;
            scanner.mErrorCallback = this.mErrorCallback;
            scanner.mAutoFocusEnabled = this.mAutoFocusEnabled;
            scanner.mSafeAutoFocusInterval = this.mAutoFocusInterval;
            scanner.mScanMode = this.mScanMode;
            scanner.mAutoFocusMode = this.mAutoFocusMode;
            scanner.mFlashEnabled = this.mFlashEnabled;
            return scanner;
        }
    }

    private final class FinishInitializationTask
    implements Runnable {
        private final Point mPreviewSize;

        private FinishInitializationTask(Point previewSize) {
            this.mPreviewSize = previewSize;
        }

        @Override
        public void run() {
            if (!CodeScanner.this.mInitialized) {
                return;
            }
            CodeScanner.this.mScannerView.setPreviewSize(this.mPreviewSize);
            CodeScanner.this.mScannerView.setAutoFocusEnabled(CodeScanner.this.isAutoFocusEnabled());
            CodeScanner.this.mScannerView.setFlashEnabled(CodeScanner.this.isFlashEnabled());
            CodeScanner.this.startPreview();
        }
    }

    private final class StopPreviewTask
    implements Runnable {
        private StopPreviewTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.stopPreview();
        }
    }

    private final class SafeAutoFocusTask
    implements Runnable {
        private SafeAutoFocusTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.mSafeAutoFocusTaskScheduled = false;
            if (CodeScanner.this.mAutoFocusMode == AutoFocusMode.SAFE) {
                CodeScanner.this.safeAutoFocusCamera();
            }
        }
    }

    private final class SafeAutoFocusCallback
    implements Camera.AutoFocusCallback {
        private SafeAutoFocusCallback() {
        }

        public void onAutoFocus(boolean success, Camera camera) {
            CodeScanner.this.mSafeAutoFocusing = false;
        }
    }

    private final class InitializationThread
    extends Thread {
        private final int mWidth;
        private final int mHeight;

        public InitializationThread(int width, int height) {
            super("Code scanner initialization thread");
            if (this.getPriority() != 1) {
                this.setPriority(1);
            }
            if (this.isDaemon()) {
                this.setDaemon(false);
            }
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        public void run() {
            try {
                this.initialize();
            }
            catch (Exception e) {
                CodeScanner.this.releaseResourcesInternal();
                ErrorCallback errorCallback = CodeScanner.this.mErrorCallback;
                if (errorCallback != null) {
                    errorCallback.onError(e);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            List flashModes;
            boolean flashSupported;
            boolean autoFocusSupported;
            Camera camera = null;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            int cameraId = CodeScanner.this.mCameraId;
            if (cameraId == -1) {
                int numberOfCameras = Camera.getNumberOfCameras();
                for (int i = 0; i < numberOfCameras; ++i) {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    camera = Camera.open((int)i);
                    CodeScanner.this.mCameraId = i;
                    break;
                }
            } else {
                camera = Camera.open((int)cameraId);
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
            }
            if (camera == null) {
                throw new CodeScannerException("Unable to access camera");
            }
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                throw new CodeScannerException("Unable to configure camera");
            }
            int orientation = Utils.getDisplayOrientation(CodeScanner.this.mContext, cameraInfo);
            boolean portrait = Utils.isPortrait(orientation);
            Point imageSize = Utils.findSuitableImageSize(parameters, portrait ? this.mHeight : this.mWidth, portrait ? this.mWidth : this.mHeight);
            int imageWidth = imageSize.getX();
            int imageHeight = imageSize.getY();
            parameters.setPreviewSize(imageWidth, imageHeight);
            Point previewSize = Utils.getPreviewSize(portrait ? imageHeight : imageWidth, portrait ? imageWidth : imageHeight, this.mWidth, this.mHeight);
            List focusModes = parameters.getSupportedFocusModes();
            boolean bl = autoFocusSupported = focusModes != null && (focusModes.contains("auto") || focusModes.contains("continuous-picture"));
            if (!autoFocusSupported) {
                CodeScanner.this.mAutoFocusEnabled = false;
            }
            if (autoFocusSupported && CodeScanner.this.mAutoFocusEnabled) {
                Utils.setAutoFocusMode(parameters, CodeScanner.this.mAutoFocusMode);
            }
            boolean bl2 = flashSupported = (flashModes = parameters.getSupportedFlashModes()) != null && flashModes.contains("torch");
            if (!flashSupported) {
                CodeScanner.this.mFlashEnabled = false;
            }
            Utils.optimizeParameters(parameters);
            CameraConfigurationUtils.setBestExposure((Camera.Parameters)parameters, (boolean)CodeScanner.this.mFlashEnabled);
            camera.setParameters(parameters);
            camera.setDisplayOrientation(orientation);
            CodeScanner.this.mInitializeLock.lock();
            try {
                Decoder decoder = new Decoder(CodeScanner.this.mDecoderStateListener, CodeScanner.this.mFormats, CodeScanner.this.mDecodeCallback);
                CodeScanner.this.mDecoderWrapper = new DecoderWrapper(camera, cameraInfo, decoder, imageSize, previewSize, new Point(this.mWidth, this.mHeight), orientation, autoFocusSupported, flashSupported);
                decoder.start();
                CodeScanner.this.mInitialization = false;
                CodeScanner.this.mInitialized = true;
            }
            finally {
                CodeScanner.this.mInitializeLock.unlock();
            }
            CodeScanner.this.mMainThreadHandler.post((Runnable)new FinishInitializationTask(previewSize));
        }
    }

    private final class DecoderStateListener
    implements Decoder.StateListener {
        private DecoderStateListener() {
        }

        @Override
        public boolean onStateChanged(@NonNull Decoder.State state) {
            if (state == Decoder.State.DECODED) {
                ScanMode scanMode = CodeScanner.this.mScanMode;
                if (scanMode == ScanMode.PREVIEW) {
                    return false;
                }
                if (scanMode == ScanMode.SINGLE) {
                    CodeScanner.this.mStoppingPreview = true;
                    CodeScanner.this.mMainThreadHandler.post(CodeScanner.this.mStopPreviewTask);
                }
            }
            return true;
        }
    }

    private final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            CodeScanner.this.startPreviewInternalSafe();
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder.getSurface() == null) {
                CodeScanner.this.mPreviewActive = false;
                return;
            }
            CodeScanner.this.stopPreviewInternalSafe();
            CodeScanner.this.startPreviewInternalSafe();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            CodeScanner.this.stopPreviewInternalSafe();
        }
    }

    private final class PreviewCallback
    implements Camera.PreviewCallback {
        private PreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            if (!CodeScanner.this.mInitialized || CodeScanner.this.mStoppingPreview || CodeScanner.this.mScanMode == ScanMode.PREVIEW || data == null) {
                return;
            }
            DecoderWrapper decoderWrapper = CodeScanner.this.mDecoderWrapper;
            if (decoderWrapper == null) {
                return;
            }
            Decoder decoder = decoderWrapper.getDecoder();
            if (decoder.isProcessing()) {
                return;
            }
            Point imageSize = decoderWrapper.getImageSize();
            Point previewSize = decoderWrapper.getPreviewSize();
            decoder.decode(new DecodeTask(data, imageSize, previewSize, decoderWrapper.getViewSize(), decoderWrapper.getDisplayOrientation(), CodeScanner.this.mScannerView.isSquareFrame(), decoderWrapper.shouldReverseHorizontal()));
        }
    }

    private final class ScannerLayoutListener
    implements CodeScannerView.LayoutListener {
        private ScannerLayoutListener() {
        }

        @Override
        public void onLayout(int width, int height) {
            CodeScanner.this.initialize(width, height);
            CodeScanner.this.mScannerView.setLayoutListener(null);
        }
    }
}

