/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Px;
import android.view.View;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;

final class ViewFinderView
extends View {
    private final Paint mMaskPaint = new Paint(1);
    private final Paint mFramePaint = new Paint(1);
    private final Path mFramePath;
    private Rect mFrameRect;
    private boolean mSquareFrame;
    private int mFrameCornerSize;

    public ViewFinderView(@NonNull Context context) {
        super(context);
        this.mFramePaint.setStyle(Paint.Style.STROKE);
        this.mFramePath = new Path();
    }

    protected void onDraw(Canvas canvas) {
        Rect frameRect = this.mFrameRect;
        if (frameRect == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        int top = frameRect.getTop();
        int left = frameRect.getLeft();
        int right = frameRect.getRight();
        int bottom = frameRect.getBottom();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)top, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)top, (float)left, (float)bottom, this.mMaskPaint);
        canvas.drawRect((float)right, (float)top, (float)width, (float)bottom, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)bottom, (float)width, (float)height, this.mMaskPaint);
        this.mFramePath.reset();
        this.mFramePath.moveTo((float)left, (float)(top + this.mFrameCornerSize));
        this.mFramePath.lineTo((float)left, (float)top);
        this.mFramePath.lineTo((float)(left + this.mFrameCornerSize), (float)top);
        this.mFramePath.moveTo((float)(right - this.mFrameCornerSize), (float)top);
        this.mFramePath.lineTo((float)right, (float)top);
        this.mFramePath.lineTo((float)right, (float)(top + this.mFrameCornerSize));
        this.mFramePath.moveTo((float)right, (float)(bottom - this.mFrameCornerSize));
        this.mFramePath.lineTo((float)right, (float)bottom);
        this.mFramePath.lineTo((float)(right - this.mFrameCornerSize), (float)bottom);
        this.mFramePath.moveTo((float)(left + this.mFrameCornerSize), (float)bottom);
        this.mFramePath.lineTo((float)left, (float)bottom);
        this.mFramePath.lineTo((float)left, (float)(bottom - this.mFrameCornerSize));
        canvas.drawPath(this.mFramePath, this.mFramePaint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mFrameRect = Utils.getViewFrameRect(this.mSquareFrame, right - left, bottom - top);
    }

    void setSquareFrame(boolean squareFrame) {
        this.mSquareFrame = squareFrame;
        if (this.mFrameRect != null) {
            this.mFrameRect = Utils.getViewFrameRect(this.mSquareFrame, this.getWidth(), this.getHeight());
        }
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    boolean isSquareFrame() {
        return this.mSquareFrame;
    }

    void setMaskColor(@ColorInt int color) {
        this.mMaskPaint.setColor(color);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameColor(@ColorInt int color) {
        this.mFramePaint.setColor(color);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameWidth(@Px int width) {
        this.mFramePaint.setStrokeWidth((float)width);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameCornersSize(@Px int size) {
        this.mFrameCornerSize = size;
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }
}

