/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.ioc;

import com.github.youyinnn.youdbutils.dao.YouDao;
import com.github.youyinnn.youdbutils.dao.YouDaoContainer;
import com.github.youyinnn.youdbutils.exceptions.AutowiredException;
import com.github.youyinnn.youdbutils.ioc.ServiceIocBean;
import com.github.youyinnn.youdbutils.ioc.annotations.Autowired;
import com.github.youyinnn.youdbutils.ioc.annotations.YouService;
import com.github.youyinnn.youdbutils.ioc.proxy.TransactionProxyGenerator;
import com.github.youyinnn.youwebutils.third.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class YouServiceIocContainer {
    private static HashMap<String, ServiceIocBean> prototypeServiceMap = new HashMap();
    private static HashMap<String, ServiceIocBean> singletonServiceMap = new HashMap();

    private YouServiceIocContainer() {
    }

    private static void addSingletonYouService(ServiceIocBean serviceBean) {
        String className = serviceBean.getClassName();
        serviceBean.setSingleton(TransactionProxyGenerator.getProxyObject(serviceBean.getServiceClass()));
        singletonServiceMap.put(className, serviceBean);
    }

    private static void addPrototypeYouService(ServiceIocBean serviceBean) {
        String className = serviceBean.getClassName();
        prototypeServiceMap.put(className, serviceBean);
    }

    public static Object getYouService(Class serviceClass) throws AutowiredException {
        ServiceIocBean serviceIocBean = singletonServiceMap.get(serviceClass.getName());
        if (serviceIocBean == null) {
            serviceIocBean = prototypeServiceMap.get(serviceClass.getName());
            if (serviceIocBean == null) {
                return null;
            }
            return YouServiceIocContainer.autowired(TransactionProxyGenerator.getProxyObject(serviceIocBean.getServiceClass()));
        }
        return YouServiceIocContainer.autowired(serviceIocBean.getSingleton());
    }

    public static void showServiceMap() {
        System.out.println("[ prototype service ]:");
        for (Map.Entry<String, ServiceIocBean> stringIocBeanEntry : prototypeServiceMap.entrySet()) {
            System.out.println(stringIocBeanEntry.getKey() + " : " + stringIocBeanEntry.getValue());
        }
        System.out.println("[ singleton service ]:");
        for (Map.Entry<String, ServiceIocBean> stringIocBeanEntry : singletonServiceMap.entrySet()) {
            System.out.println(stringIocBeanEntry.getKey() + " : " + stringIocBeanEntry.getValue());
        }
    }

    private static boolean hasYouService(Class youService) {
        return singletonServiceMap.containsKey(youService.getName()) | prototypeServiceMap.containsKey(youService.getName());
    }

    private static Object autowired(Object youService) throws AutowiredException {
        ArrayList declaredFields = ReflectionUtils.getDeclaredFields((Object)youService, Autowired.class);
        for (Field declaredField : declaredFields) {
            Class<?> type = declaredField.getType();
            YouService youServiceAnnotation = type.getAnnotation(YouService.class);
            if (youServiceAnnotation == null) {
                if ("YouDao".equals(type.getSuperclass().getSimpleName())) {
                    YouDao autowiredDao = YouDaoContainer.getDao(type);
                    ReflectionUtils.setFieldValue((Object)youService, (String)declaredField.getName(), (Object)autowiredDao);
                    continue;
                }
                throw new AutowiredException("\u4e0d\u652f\u6301\u7684\u81ea\u52a8\u88c5\u914d\u7c7b\u578b\uff1a[" + type.getSimpleName() + " " + declaredField.getName() + "].");
            }
            Object autowiredDaoYouService = YouServiceIocContainer.getYouService(type);
            ReflectionUtils.setFieldValue((Object)youService, (String)declaredField.getName(), (Object)autowiredDaoYouService);
        }
        return youService;
    }

    static void registerYouService(Class<?> aClass) {
        YouService youService = aClass.getAnnotation(YouService.class);
        if (!YouServiceIocContainer.hasYouService(aClass)) {
            if (youService.scope().equals("singleton")) {
                YouServiceIocContainer.addSingletonYouService(new ServiceIocBean(aClass, "singleton"));
            } else {
                YouServiceIocContainer.addPrototypeYouService(new ServiceIocBean(aClass, "prototype"));
            }
        }
    }

    public static Set<String> getPrototypeServiceMap() {
        return prototypeServiceMap.keySet();
    }

    public static Set<String> getSingletonServiceMap() {
        return singletonServiceMap.keySet();
    }
}

