/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.druid;

import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.github.youyinnn.youdbutils.druid.filter.YouLog4j2FilterConfig;
import com.github.youyinnn.youdbutils.druid.filter.YouStatFilterConfig;
import com.github.youyinnn.youdbutils.exceptions.DataSourceInitException;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class YouDruid {
    private static final String MYSQL_PROPERTIES_FILE = "conf/mysql.properties";
    private static final String SQLITE_PROPERTIES_FILE = "conf/sqlite.properties";
    private static final String MYSQL_TYPE = "mysql";
    private static final String SQLITE_TYPE = "sqlite";
    private DruidDataSource currentDataSource;
    private String dataSourceName;
    private boolean embeddedLogEnable = false;
    private String userName;
    private String password;
    private String url;
    private String driverClass;

    private YouDruid() {
    }

    public DruidDataSource getCurrentDataSource() {
        return this.currentDataSource;
    }

    public Connection getCurrentDataSourceConn() throws SQLException {
        return this.currentDataSource.getConnection();
    }

    public void printDataSource() {
        System.out.println("Url:" + this.currentDataSource.getUrl() + "\r\nDataSourceName:" + this.getDataSourceName());
    }

    public static YouDruid initMySQLDataSource(String dataSourceName) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, null, dataSourceName, false, null, null);
    }

    public static YouDruid initMySQLDataSource(String dataSourceName, boolean embeddedLogEnable) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, null, dataSourceName, embeddedLogEnable, null, null);
    }

    public static YouDruid initMySQLDataSource(String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, null, dataSourceName, embeddedLogEnable, log4j2FilterConfig, null);
    }

    public static YouDruid initMySQLDataSource(String dataSourceName, boolean embeddedLogEnable, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, null, dataSourceName, embeddedLogEnable, null, statFilterConfig);
    }

    public static YouDruid initMySQLDataSource(String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, null, dataSourceName, embeddedLogEnable, log4j2FilterConfig, statFilterConfig);
    }

    public static YouDruid initMySQLDataSource(String propFilePath, String dataSourceName) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, propFilePath, dataSourceName, false, null, null);
    }

    public static YouDruid initMySQLDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, propFilePath, dataSourceName, embeddedLogEnable, null, null);
    }

    public static YouDruid initMySQLDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, propFilePath, dataSourceName, embeddedLogEnable, log4j2FilterConfig, null);
    }

    public static YouDruid initMySQLDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, propFilePath, dataSourceName, embeddedLogEnable, null, statFilterConfig);
    }

    public static YouDruid initMySQLDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(MYSQL_TYPE, propFilePath, dataSourceName, embeddedLogEnable, log4j2FilterConfig, statFilterConfig);
    }

    public static YouDruid initSQLiteDataSource(String dataSourceName) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, null, dataSourceName, false, null, null);
    }

    public static YouDruid initSQLiteDataSource(String dataSourceName, boolean embeddedLogEnable) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, null, dataSourceName, embeddedLogEnable, null, null);
    }

    public static YouDruid initSQLiteDataSource(String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, null, dataSourceName, embeddedLogEnable, log4j2FilterConfig, null);
    }

    public static YouDruid initSQLiteDataSource(String dataSourceName, boolean embeddedLogEnable, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, null, dataSourceName, embeddedLogEnable, null, statFilterConfig);
    }

    public static YouDruid initSQLiteDataSource(String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, null, dataSourceName, embeddedLogEnable, log4j2FilterConfig, statFilterConfig);
    }

    public static YouDruid initSQLiteDataSource(String propFilePath, String dataSourceName) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, propFilePath, dataSourceName, false, null, null);
    }

    public static YouDruid initSQLiteDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, propFilePath, dataSourceName, embeddedLogEnable, null, null);
    }

    public static YouDruid initSQLiteDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, propFilePath, dataSourceName, embeddedLogEnable, log4j2FilterConfig, null);
    }

    public static YouDruid initSQLiteDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, propFilePath, dataSourceName, embeddedLogEnable, null, statFilterConfig);
    }

    public static YouDruid initSQLiteDataSource(String propFilePath, String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        return YouDruid.generateDataSource(SQLITE_TYPE, propFilePath, dataSourceName, embeddedLogEnable, log4j2FilterConfig, statFilterConfig);
    }

    private static YouDruid generateDataSource(String dataSourceType, String propertiesFile, String dataSourceName, boolean embeddedLogEnable, YouLog4j2FilterConfig log4j2FilterConfig, YouStatFilterConfig statFilterConfig) throws DataSourceInitException {
        InputStream inputStream;
        Logger druidLog = Log4j2Helper.getLogger((String)"$db_druid");
        YouDruid youDruid = new YouDruid();
        youDruid.embeddedLogEnable = embeddedLogEnable;
        if (dataSourceName == null || dataSourceName.length() == 0) {
            throw new DataSourceInitException("\u5fc5\u987b\u6307\u5b9a\u6570\u636e\u6e90\u540d!");
        }
        youDruid.dataSourceName = dataSourceName;
        Properties properties = new Properties();
        if (propertiesFile == null) {
            if (MYSQL_TYPE.equals(dataSourceType)) {
                propertiesFile = MYSQL_PROPERTIES_FILE;
            } else if (SQLITE_TYPE.equals(dataSourceType)) {
                propertiesFile = SQLITE_PROPERTIES_FILE;
            }
        }
        if ((inputStream = YouDruid.class.getClassLoader().getResourceAsStream(propertiesFile)) != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                youDruid.currentDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
                if (MYSQL_TYPE.equals(dataSourceType)) {
                    youDruid.currentDataSource.addFilters("wall");
                }
                ArrayList<Object> filters = new ArrayList<Object>();
                if (log4j2FilterConfig != null) {
                    Log4j2Filter log4j2Filter = log4j2FilterConfig.configLog4j2Filter(new Log4j2Filter());
                    filters.add(log4j2Filter);
                }
                if (statFilterConfig != null) {
                    StatFilter statFilter = statFilterConfig.configStatFilter(new StatFilter());
                    Long timeBetweenLogStatusMillis = statFilterConfig.getTimeBetweenLogStatusMillis();
                    if (timeBetweenLogStatusMillis != null) {
                        youDruid.currentDataSource.setTimeBetweenLogStatsMillis(timeBetweenLogStatusMillis.longValue());
                    }
                    filters.add(statFilter);
                }
                youDruid.currentDataSource.setProxyFilters(filters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                youDruid.currentDataSource.init();
                youDruid.userName = properties.getProperty("username");
                youDruid.password = properties.getProperty("password");
                youDruid.url = properties.getProperty("url");
                youDruid.driverClass = properties.getProperty("driverClass");
                if (youDruid.driverClass == null) {
                    youDruid.driverClass = youDruid.currentDataSource.getDriverClassName();
                }
                if (youDruid.embeddedLogEnable) {
                    druidLog.info("\u6570\u636e\u6e90\u521d\u59cb\u5316\u6210\u529f, Url:{} , DataSourceName: {}.", (Object)youDruid.currentDataSource.getUrl().split("\\?")[0], (Object)dataSourceName);
                }
            }
            catch (SQLException e) {
                if (youDruid.embeddedLogEnable) {
                    druidLog.error("\u6570\u636e\u6e90\u521d\u59cb\u5316\u5931\u8d25, Url:{} , DataSourceName: {}.", (Object)youDruid.currentDataSource.getUrl().split("\\?")[0], (Object)dataSourceName);
                }
                System.exit(0);
            }
        } else {
            try {
                throw new DataSourceInitException("Resource\u8def\u5f84[" + propertiesFile + "]\u4e0b\u6ca1\u6709\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u53ef\u52a0\u8f7d\uff01");
            }
            catch (DataSourceInitException e) {
                e.printStackTrace();
            }
        }
        return youDruid;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean isEmbeddedLogEnable() {
        return this.embeddedLogEnable;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    static {
        try {
            Log4j2Helper.useConfig((URL)YouDruid.class.getResource("/$dbconf/$youdblog4j2.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

