/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao.model;

import com.github.youyinnn.youdbutils.YouDbManager;
import com.github.youyinnn.youdbutils.dao.model.ModelTableMessage;
import com.github.youyinnn.youdbutils.druid.ThreadLocalPropContainer;
import com.github.youyinnn.youwebutils.third.ClassUtils;
import com.github.youyinnn.youwebutils.third.DbUtils;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ModelTableScanner {
    private static final Logger logger = Log4j2Helper.getLogger((String)"$db_manager");

    private ModelTableScanner() {
    }

    public static void scanPackageForModel(String modelPackageNamePrefix, String dataSourceName) {
        Set modelClassSet = ClassUtils.findFileClass((String)modelPackageNamePrefix);
        if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
            logger.info("\u6570\u636e\u6e90: \"{}\" \u6240\u7ba1\u7406\u7684Model\u7c7b\u626b\u63cf\u7ed3\u679c\u4e3a: {}.", (Object)dataSourceName, (Object)modelClassSet);
        }
        for (Class aClass : modelClassSet) {
            Field[] declaredFields = aClass.getDeclaredFields();
            ArrayList<String> fieldList = new ArrayList<String>();
            for (Field declaredField : declaredFields) {
                fieldList.add(declaredField.getName());
            }
            ModelTableMessage.registerModelFieldMessage(aClass.getSimpleName(), fieldList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanDataBaseForTable(Set<String> modelNameSet, Connection connection, String dataSourceName) {
        try {
            ArrayList tablesFromDB = DbUtils.getTablesFromDB((Connection)connection);
            if (tablesFromDB.size() == 0) {
                if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                    logger.info("\u626b\u63cf\u6570\u636e\u6e90:\"{}\", \u6ca1\u6709\u4efb\u4f55\u8868, \u5c1d\u8bd5\u7d22\u5f15\u914d\u7f6e\u597d\u7684\u521d\u59cb\u5316SQL\u6587\u4ef6.", (Object)dataSourceName);
                }
                ModelTableScanner.checkTableAndTryToCreate(dataSourceName, connection);
            }
            tablesFromDB = DbUtils.getTablesFromDB((Connection)connection);
            for (String modelName : modelNameSet) {
                String tableName = modelName.toLowerCase();
                String alibabaTableName = DbUtils.turnToAlibabaDataBaseNamingRules((String)modelName);
                if (!tablesFromDB.contains(tableName) && YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                    logger.info("\u6570\u636e\u6e90: \"{}\" \u4e2d\u6ca1\u6709\u8868:{}, \u5c1d\u8bd5\u5bfb\u627e\u8868:{}", (Object)dataSourceName, (Object)tableName, (Object)alibabaTableName);
                }
                if (!tablesFromDB.contains(alibabaTableName)) {
                    if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                        logger.info("\u6570\u636e\u6e90: \"{}\" \u4e2d\u6ca1\u6709\u8868:{}.", (Object)dataSourceName, (Object)alibabaTableName);
                    }
                    ModelTableScanner.checkTableAndTryToCreate(dataSourceName, connection);
                    tableName = alibabaTableName;
                } else {
                    tableName = alibabaTableName;
                }
                ArrayList columnsFromTable = DbUtils.getColumnsFromTable((Connection)connection, (String)tableName);
                ModelTableMessage.registerModelTableNameMappingMessage(modelName, tableName);
                ModelTableMessage.registerTableFieldMessage(modelName, columnsFromTable);
            }
            tablesFromDB = DbUtils.getTablesFromDB((Connection)connection);
            if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                logger.info("\u6570\u636e\u6e90: \"{}\" \u4e2d\u6240\u5305\u542b\u7684\u8868\u6709: \"{}\".", (Object)dataSourceName, (Object)tablesFromDB);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ThreadLocalPropContainer.release(null, null, connection);
        }
    }

    private static void checkTableAndTryToCreate(String dataSourceName, Connection connection) throws Exception {
        URL dataSourceInitSqlFileURL = YouDbManager.getDataSourceInitSqlFileURL(dataSourceName);
        if (dataSourceInitSqlFileURL != null) {
            if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                logger.info("\u6b63\u5728\u4f7f\u7528\u914d\u7f6e\u7684\u521d\u59cb\u5316SQL\u6587\u4ef6, \u5e76\u6267\u884c\u6587\u4ef6....");
            }
            DbUtils.runSqlScript((Connection)connection, (InputStream)dataSourceInitSqlFileURL.openStream());
        } else {
            if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                logger.error("\u5c1d\u8bd5\u521d\u59cb\u5316\u8868\u65f6\u7ec8\u6b62, \u7528\u6237\u65e2\u6ca1\u6709\u6307\u5b9a\u7528\u4e8e\u521d\u59cb\u5316\u7684SQL\u6587\u4ef6, \u9ed8\u8ba4\u8d44\u6e90\u8def\u5f84\u4e0b\u4e5f\u6ca1\u6709{}\u6587\u4ef6!", (Object)(dataSourceName + "-init.sql"));
            }
            System.exit(0);
        }
    }
}

