/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao;

import com.github.youyinnn.youdbutils.druid.ThreadLocalPropContainer;
import com.github.youyinnn.youdbutils.exceptions.NoneffectiveUpdateExecuteException;
import com.github.youyinnn.youdbutils.utils.SqlStringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SqlExecutor
implements com.github.youyinnn.youdbutils.dao.interfaces.SqlExecutor {
    private String dataSourceName;

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    private ResultSet statementQuery(Connection conn, String sql) throws SQLException {
        Statement statement = conn.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        return resultSet;
    }

    private ResultSet preparedStatementQuery(Connection conn, String sql, Collection conditionValues) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        int i = 1;
        for (Object value : conditionValues) {
            ps.setObject(i++, value);
        }
        ResultSet resultSet = ps.executeQuery();
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int preparedStatementUpdate(Connection conn, String sql, Collection newFieldValues, Collection conditionValues) throws NoneffectiveUpdateExecuteException {
        int result = 0;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            int i = 1;
            if (newFieldValues != null) {
                for (Object newFieldValue : newFieldValues) {
                    ps.setObject(i++, newFieldValue);
                }
            }
            if (conditionValues != null) {
                for (Object conditionValue : conditionValues) {
                    ps.setObject(i++, conditionValue);
                }
            }
            result = ps.executeUpdate();
        }
        catch (SQLException e) {
            ThreadLocalPropContainer.setRollbackFlagTrue();
            e.printStackTrace();
        }
        finally {
            ThreadLocalPropContainer.release(null, ps, null);
        }
        if (result == 0 & ThreadLocalPropContainer.getNoneffectiveUpdateFlag() == false) {
            ThreadLocalPropContainer.setRollbackFlagTrue();
            throw new NoneffectiveUpdateExecuteException("\u4e0d\u5141\u8bb8\u5b58\u5728\u65e0\u6548\u7684\u66f4\u65b0\u64cd\u4f5c");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeStatementUpdate(String sql) throws NoneffectiveUpdateExecuteException {
        int result = 0;
        Connection conn = ThreadLocalPropContainer.getThreadConnection(this.dataSourceName);
        Statement statement = null;
        try {
            statement = conn.createStatement();
            result = statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            ThreadLocalPropContainer.setRollbackFlagTrue();
            e.printStackTrace();
        }
        finally {
            ThreadLocalPropContainer.release(null, statement, null);
        }
        if (result == 0 & ThreadLocalPropContainer.getNoneffectiveUpdateFlag() == false) {
            ThreadLocalPropContainer.setRollbackFlagTrue();
            throw new NoneffectiveUpdateExecuteException("\u4e0d\u5141\u8bb8\u5b58\u5728\u65e0\u6548\u7684\u66f4\u65b0\u64cd\u4f5c");
        }
        return result;
    }

    @Override
    public int executePreparedStatementUpdate(String tableName, HashMap<String, Object> newFieldValuesMap, HashMap<String, Object> conditionsMap, String separateMark) throws NoneffectiveUpdateExecuteException {
        String sql = SqlStringUtils.getUpdateSetWhereSql(tableName, newFieldValuesMap.keySet(), separateMark, conditionsMap != null ? conditionsMap.keySet() : null);
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, newFieldValuesMap.values(), conditionsMap != null ? conditionsMap.values() : null);
    }

    @Override
    public int executePreparedStatementUpdate(String sql, ArrayList newFieldValues, ArrayList conditionValues) throws NoneffectiveUpdateExecuteException {
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, newFieldValues, conditionValues);
    }

    @Override
    public int executeStatementInsert(String sql) throws NoneffectiveUpdateExecuteException {
        return this.executeStatementUpdate(sql);
    }

    @Override
    public int executePreparedStatementInsert(String sql, ArrayList newFieldValues) throws NoneffectiveUpdateExecuteException {
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, newFieldValues, null);
    }

    @Override
    public int executePreparedStatementInsert(String tableName, HashMap<String, Object> newFieldValuesMap) throws NoneffectiveUpdateExecuteException {
        String sql = SqlStringUtils.getInsertSql(tableName, newFieldValuesMap.keySet());
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, newFieldValuesMap.values(), null);
    }

    @Override
    public int executeStatementDelete(String sql) throws NoneffectiveUpdateExecuteException {
        return this.executeStatementUpdate(sql);
    }

    @Override
    public int executePreparedStatementDelete(String sql, ArrayList conditionValues) throws NoneffectiveUpdateExecuteException {
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, null, conditionValues);
    }

    @Override
    public int executePreparedStatementDelete(String tableName, HashMap<String, Object> conditionsMap, String separateMark) throws NoneffectiveUpdateExecuteException {
        String sql = SqlStringUtils.getDeleteSql(tableName, separateMark, conditionsMap.keySet());
        return this.preparedStatementUpdate(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, null, conditionsMap.values());
    }

    @Override
    public ResultSet executeStatementQuery(String sql) throws SQLException {
        return this.statementQuery(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql);
    }

    @Override
    public ResultSet executePreparedStatementQuery(String sql, ArrayList values) throws SQLException {
        return this.preparedStatementQuery(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, values);
    }

    @Override
    public ResultSet executePreparedStatementQuery(String tableName, ArrayList<String> queryFieldList, HashMap<String, Object> conditionMap, String separateMark) throws SQLException {
        String sql = SqlStringUtils.getSelectFromWhereSql(tableName, conditionMap.keySet(), separateMark, queryFieldList);
        return this.preparedStatementQuery(ThreadLocalPropContainer.getThreadConnection(this.dataSourceName), sql, conditionMap.values());
    }
}

