/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import com.hw.videoprocessor.util.CL;

public class FrameDropper {
    private int srcFrameRate;
    private int dstFrameRate;
    private boolean disable;
    private int dropCount;
    private int keepCount;

    public FrameDropper(int srcFrameRate, int dstFrameRate) {
        this.srcFrameRate = srcFrameRate;
        this.dstFrameRate = dstFrameRate;
        if (srcFrameRate <= dstFrameRate) {
            CL.e("\u539f\u59cb\u5e27\u7387:" + srcFrameRate + "\u5c0f\u4e8e\u76ee\u6807\u5e27\u7387:" + dstFrameRate + "\uff0c\u4e0d\u652f\u6301\u8865\u5e27", new Object[0]);
            this.disable = true;
        }
    }

    public boolean checkDrop(int frameIndex) {
        boolean drop;
        if (this.disable) {
            return false;
        }
        if (frameIndex == 0) {
            ++this.keepCount;
            return false;
        }
        float targetDropRate = (float)(this.srcFrameRate - this.dstFrameRate) / (float)this.srcFrameRate;
        float ifDropRate = (float)(this.dropCount + 1) / (float)(this.dropCount + this.keepCount);
        float ifNotDropRate = (float)this.dropCount / (float)(this.dropCount + this.keepCount + 1);
        boolean bl = drop = Math.abs(ifDropRate - targetDropRate) < Math.abs(ifNotDropRate - targetDropRate);
        if (drop) {
            ++this.dropCount;
        } else {
            ++this.keepCount;
        }
        return drop;
    }

    public void printResult() {
        if (this.disable) {
            return;
        }
        int totalFrame = this.dropCount + this.keepCount;
        float duration = (float)totalFrame / (float)this.srcFrameRate;
        float realFrameRate = (float)this.keepCount / duration;
        float targetDropRate = (float)(this.srcFrameRate - this.dstFrameRate) / (float)this.srcFrameRate;
        CL.i("\u6700\u7ec8\u5e27\u7387\u4e3a:" + realFrameRate, new Object[0]);
        CL.i("\u5b9e\u9645\u4e22\u5e27\u7387:" + (float)this.dropCount / (float)(this.dropCount + this.keepCount) + " \u76ee\u6807\u4e22\u5e27\u7387:" + targetDropRate, new Object[0]);
    }
}

