/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.hw.videoprocessor.ApiHelper;
import com.hw.videoprocessor.IVideoEncodeThread;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.InputSurface;
import com.hw.videoprocessor.util.OutputSurface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoDecodeThread
extends Thread {
    private MediaExtractor mExtractor;
    private MediaCodec mDecoder;
    private Integer mStartTimeMs;
    private Integer mEndTimeMs;
    private Float mSpeed;
    private AtomicBoolean mDecodeDone;
    private Exception mException;
    private int mVideoIndex;
    private IVideoEncodeThread mVideoEncodeThread;
    private InputSurface mInputSurface;
    private OutputSurface mOutputSurface;
    private Integer mDstFrameRate;
    private Integer mSrcFrameRate;
    private boolean mDropFrames;

    public VideoDecodeThread(IVideoEncodeThread videoEncodeThread, MediaExtractor extractor, @Nullable Integer startTimeMs, @Nullable Integer endTimeMs, @Nullable Integer srcFrameRate, @Nullable Integer dstFrameRate, @Nullable Float speed, boolean dropFrames, int videoIndex, AtomicBoolean decodeDone) {
        super("VideoProcessDecodeThread");
        this.mExtractor = extractor;
        this.mStartTimeMs = startTimeMs;
        this.mEndTimeMs = endTimeMs;
        this.mSpeed = speed;
        this.mVideoIndex = videoIndex;
        this.mDecodeDone = decodeDone;
        this.mVideoEncodeThread = videoEncodeThread;
        this.mDstFrameRate = dstFrameRate;
        this.mSrcFrameRate = srcFrameRate;
        this.mDropFrames = dropFrames;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block18: {
            block17: {
                super.run();
                this.doDecode();
                if (this.mInputSurface != null) {
                    this.mInputSurface.release();
                }
                if (this.mOutputSurface == null) break block17;
                this.mOutputSurface.release();
            }
            try {
                if (this.mDecoder != null) {
                    this.mDecoder.stop();
                    this.mDecoder.release();
                }
                break block18;
            }
            catch (Exception e) {
                this.mException = this.mException == null ? e : this.mException;
                CL.e(e);
            }
            break block18;
            catch (Exception e) {
                block19: {
                    try {
                        this.mException = e;
                        CL.e(e);
                        if (this.mInputSurface != null) {
                            this.mInputSurface.release();
                        }
                        if (this.mOutputSurface == null) break block19;
                        this.mOutputSurface.release();
                    }
                    catch (Throwable throwable) {
                        if (this.mInputSurface != null) {
                            this.mInputSurface.release();
                        }
                        if (this.mOutputSurface != null) {
                            this.mOutputSurface.release();
                        }
                        try {
                            if (this.mDecoder != null) {
                                this.mDecoder.stop();
                                this.mDecoder.release();
                            }
                        }
                        catch (Exception e2) {
                            this.mException = this.mException == null ? e2 : this.mException;
                            CL.e(e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (this.mDecoder != null) {
                        this.mDecoder.stop();
                        this.mDecoder.release();
                    }
                }
                catch (Exception e3) {
                    this.mException = this.mException == null ? e3 : this.mException;
                    CL.e(e3);
                }
            }
        }
    }

    private void doDecode() throws IOException {
        CountDownLatch eglContextLatch = this.mVideoEncodeThread.getEglContextLatch();
        try {
            boolean await = eglContextLatch.await(5L, TimeUnit.SECONDS);
            if (!await) {
                this.mException = new TimeoutException("wait eglContext timeout!");
                return;
            }
        }
        catch (InterruptedException e) {
            CL.e(e);
            this.mException = e;
            return;
        }
        Surface encodeSurface = this.mVideoEncodeThread.getSurface();
        this.mInputSurface = new InputSurface(encodeSurface);
        this.mInputSurface.makeCurrent();
        MediaFormat inputFormat = this.mExtractor.getTrackFormat(this.mVideoIndex);
        this.mDecoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        this.mOutputSurface = new OutputSurface();
        this.mDecoder.configure(inputFormat, this.mOutputSurface.getSurface(), null, 0);
        this.mDecoder.start();
        int frameIntervalForDrop = 0;
        int dropCount = 0;
        int frameIndex = 1;
        if (this.mDropFrames && this.mSrcFrameRate != null && this.mDstFrameRate != null) {
            if (this.mSpeed != null) {
                this.mSrcFrameRate = (int)((float)this.mSrcFrameRate.intValue() * this.mSpeed.floatValue());
            }
            if (this.mSrcFrameRate > this.mDstFrameRate) {
                frameIntervalForDrop = this.mDstFrameRate / (this.mSrcFrameRate - this.mDstFrameRate);
                frameIntervalForDrop = frameIntervalForDrop == 0 ? 1 : frameIntervalForDrop;
                dropCount = (this.mSrcFrameRate - this.mDstFrameRate) / this.mDstFrameRate;
                dropCount = dropCount == 0 ? 1 : dropCount;
                CL.w("\u5e27\u7387\u8fc7\u9ad8\uff0c\u9700\u8981\u4e22\u5e27:" + this.mSrcFrameRate + "->" + this.mDstFrameRate + " frameIntervalForDrop:" + frameIntervalForDrop + " dropCount:" + dropCount, new Object[0]);
            }
        }
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        boolean decoderDone = false;
        boolean inputDone = false;
        long videoStartTimeUs = -1L;
        int decodeTryAgainCount = 0;
        ByteBuffer[] inputBuffers = null;
        if (!ApiHelper.AFTER_LOLLIPOP) {
            inputBuffers = this.mDecoder.getInputBuffers();
        }
        block4: while (!decoderDone) {
            boolean decoderOutputAvailable;
            if (!inputDone) {
                int inputBufIndex;
                boolean eof = false;
                int index = this.mExtractor.getSampleTrackIndex();
                if (index == this.mVideoIndex) {
                    inputBufIndex = this.mDecoder.dequeueInputBuffer(2500L);
                    if (inputBufIndex >= 0) {
                        ByteBuffer inputBuf = ApiHelper.AFTER_LOLLIPOP ? this.mDecoder.getInputBuffer(inputBufIndex) : inputBuffers[inputBufIndex];
                        int chunkSize = this.mExtractor.readSampleData(inputBuf, 0);
                        if (chunkSize < 0) {
                            this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                            decoderDone = true;
                        } else {
                            long sampleTime = this.mExtractor.getSampleTime();
                            this.mDecoder.queueInputBuffer(inputBufIndex, 0, chunkSize, sampleTime, 0);
                            this.mExtractor.advance();
                        }
                    }
                } else if (index == -1) {
                    eof = true;
                }
                if (eof) {
                    CL.i("inputDone", new Object[0]);
                    inputBufIndex = this.mDecoder.dequeueInputBuffer(2500L);
                    if (inputBufIndex >= 0) {
                        this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                        inputDone = true;
                    }
                }
            }
            boolean bl = decoderOutputAvailable = !decoderDone;
            if (decoderDone) {
                CL.i("decoderOutputAvailable:" + decoderOutputAvailable, new Object[0]);
            }
            while (decoderOutputAvailable) {
                int remainder;
                int outputBufferIndex = this.mDecoder.dequeueOutputBuffer(info, 2500L);
                CL.i("outputBufferIndex = " + outputBufferIndex, new Object[0]);
                if (inputDone && outputBufferIndex == -1) {
                    if (++decodeTryAgainCount > 10) {
                        CL.e("INFO_TRY_AGAIN_LATER 10 times,force End!", new Object[0]);
                        decoderDone = true;
                        continue block4;
                    }
                } else {
                    decodeTryAgainCount = 0;
                }
                if (outputBufferIndex == -1) continue block4;
                if (outputBufferIndex == -2) {
                    MediaFormat newFormat = this.mDecoder.getOutputFormat();
                    CL.i("decode newFormat = " + newFormat, new Object[0]);
                    continue;
                }
                if (outputBufferIndex < 0) {
                    CL.e("unexpected result from decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                    continue;
                }
                boolean doRender = true;
                if (this.mEndTimeMs != null && info.presentationTimeUs >= (long)(this.mEndTimeMs * 1000)) {
                    inputDone = true;
                    decoderDone = true;
                    doRender = false;
                    info.flags |= 4;
                }
                if (this.mStartTimeMs != null && info.presentationTimeUs < (long)(this.mStartTimeMs * 1000)) {
                    doRender = false;
                    CL.e("drop frame startTime = " + this.mStartTimeMs + " present time = " + info.presentationTimeUs / 1000L, new Object[0]);
                }
                if (info.flags == 4) {
                    decoderDone = true;
                    this.mDecoder.releaseOutputBuffer(outputBufferIndex, false);
                    CL.i("decoderDone", new Object[0]);
                    continue block4;
                }
                if (frameIntervalForDrop > 0 && ((remainder = frameIndex % (frameIntervalForDrop + dropCount)) > frameIntervalForDrop || remainder == 0)) {
                    CL.w("\u5e27\u7387\u8fc7\u9ad8\uff0c\u4e22\u5e27:" + frameIndex, new Object[0]);
                    doRender = false;
                }
                ++frameIndex;
                this.mDecoder.releaseOutputBuffer(outputBufferIndex, doRender);
                if (!doRender) continue;
                boolean errorWait = false;
                try {
                    this.mOutputSurface.awaitNewImage();
                }
                catch (Exception e) {
                    errorWait = true;
                    CL.e(e.getMessage(), new Object[0]);
                }
                if (errorWait) continue;
                if (videoStartTimeUs == -1L) {
                    videoStartTimeUs = info.presentationTimeUs;
                    CL.i("videoStartTime:" + videoStartTimeUs / 1000L, new Object[0]);
                }
                this.mOutputSurface.drawImage(false);
                long presentationTimeNs = (info.presentationTimeUs - videoStartTimeUs) * 1000L;
                if (this.mSpeed != null) {
                    presentationTimeNs = (long)((float)presentationTimeNs / this.mSpeed.floatValue());
                }
                CL.i("drawImage,setPresentationTimeMs:" + presentationTimeNs / 1000L / 1000L, new Object[0]);
                this.mInputSurface.setPresentationTime(presentationTimeNs);
                this.mInputSurface.swapBuffers();
                continue block4;
            }
        }
        this.mDecodeDone.set(true);
    }

    public Exception getException() {
        return this.mException;
    }
}

