/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.content.Context;
import android.media.MediaExtractor;
import android.media.MediaMuxer;
import android.support.annotation.Nullable;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.AudioUtil;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.VideoProgressAve;
import com.hw.videoprocessor.util.VideoProgressListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AudioProcessThread
extends Thread
implements VideoProgressListener {
    private String mVidepPath;
    private Integer mStartTimeMs;
    private Integer mEndTimeMs;
    private Float mSpeed;
    private Context mContext;
    private Exception mException;
    private MediaMuxer mMuxer;
    private int mMuxerAudioTrackIndex;
    private MediaExtractor mExtractor;
    private CountDownLatch mMuxerStartLatch;
    private VideoProgressAve mProgressAve;

    public AudioProcessThread(Context context, String videoPath, MediaMuxer muxer, @Nullable Integer startTimeMs, @Nullable Integer endTimeMs, @Nullable Float speed, int muxerAudioTrackIndex, CountDownLatch muxerStartLatch) {
        super("VideoProcessDecodeThread");
        this.mVidepPath = videoPath;
        this.mStartTimeMs = startTimeMs;
        this.mEndTimeMs = endTimeMs;
        this.mSpeed = speed;
        this.mMuxer = muxer;
        this.mContext = context;
        this.mMuxerAudioTrackIndex = muxerAudioTrackIndex;
        this.mExtractor = new MediaExtractor();
        this.mMuxerStartLatch = muxerStartLatch;
    }

    @Override
    public void run() {
        super.run();
        try {
            this.doProcessAudio();
        }
        catch (Exception e) {
            this.mException = e;
            CL.e(e);
        }
        finally {
            this.mExtractor.release();
        }
    }

    private void doProcessAudio() throws Exception {
        this.mExtractor.setDataSource(this.mVidepPath);
        int audioTrackIndex = VideoUtil.selectTrack(this.mExtractor, true);
        if (audioTrackIndex >= 0) {
            this.mExtractor.selectTrack(audioTrackIndex);
            Integer startTimeUs = this.mStartTimeMs == null ? null : Integer.valueOf(this.mStartTimeMs * 1000);
            Integer endTimeUs = this.mEndTimeMs == null ? null : Integer.valueOf(this.mEndTimeMs * 1000);
            boolean await = this.mMuxerStartLatch.await(3L, TimeUnit.SECONDS);
            if (!await) {
                throw new TimeoutException("wait muxerStartLatch timeout!");
            }
            if (this.mSpeed != null) {
                AudioUtil.writeAudioTrackDecode(this.mContext, this.mExtractor, this.mMuxer, this.mMuxerAudioTrackIndex, startTimeUs, endTimeUs, this.mSpeed, this);
            } else {
                AudioUtil.writeAudioTrack(this.mExtractor, this.mMuxer, this.mMuxerAudioTrackIndex, startTimeUs, endTimeUs, this);
            }
        }
        if (this.mProgressAve != null) {
            this.mProgressAve.setAudioProgress(1.0f);
        }
    }

    public Exception getException() {
        return this.mException;
    }

    public void setProgressAve(VideoProgressAve progressAve) {
        this.mProgressAve = progressAve;
    }

    @Override
    public void onProgress(float progress) {
        if (this.mProgressAve != null) {
            this.mProgressAve.setAudioProgress(progress);
        }
    }
}

