/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.hw.videoprocessor.AudioProcessThread;
import com.hw.videoprocessor.VideoDecodeThread;
import com.hw.videoprocessor.VideoEncodeThread;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.AudioFadeUtil;
import com.hw.videoprocessor.util.AudioUtil;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.PcmToWavUtil;
import com.hw.videoprocessor.util.VideoMultiStepProgress;
import com.hw.videoprocessor.util.VideoProgressAve;
import com.hw.videoprocessor.util.VideoProgressListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public class VideoProcessor {
    static final String TAG = "VideoProcessor";
    static final String MIME_TYPE = "video/avc";
    public static boolean DROP_FRAMES = true;
    public static int DEFAULT_FRAME_RATE = 20;
    public static final int DEFAULT_I_FRAME_INTERVAL = 1;
    public static final int DEFAULT_AAC_BITRATE = 192000;
    public static boolean AUDIO_MIX_REPEAT = true;
    static final int TIMEOUT_USEC = 2500;

    public static void scaleVideo(Context context, String input, String output, int outWidth, int outHeight) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).outWidth(outWidth).outHeight(outHeight).process();
    }

    public static void cutVideo(Context context, String input, String output, int startTimeMs, int endTimeMs) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).startTimeMs(startTimeMs).endTimeMs(endTimeMs).process();
    }

    public static void changeVideoSpeed(Context context, String input, String output, float speed) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).speed(speed).process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseVideo(Context context, String input, String output, @Nullable VideoProgressListener listener) throws Exception {
        block8: {
            File tempFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp");
            File temp2File = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp2");
            try {
                MediaExtractor extractor = new MediaExtractor();
                extractor.setDataSource(input);
                int trackIndex = VideoUtil.selectTrack(extractor, false);
                extractor.selectTrack(trackIndex);
                int keyFrameCount = 0;
                int frameCount = 0;
                while (true) {
                    long sampleTime;
                    int flags;
                    if ((flags = extractor.getSampleFlags()) > 0 && (flags & 1) != 0) {
                        ++keyFrameCount;
                    }
                    if ((sampleTime = extractor.getSampleTime()) < 0L) break;
                    ++frameCount;
                    extractor.advance();
                }
                extractor.release();
                if (frameCount == keyFrameCount || frameCount == keyFrameCount + 1) {
                    VideoProcessor.reverseVideoNoDecode(input, output, listener);
                    break block8;
                }
                VideoMultiStepProgress stepProgress = new VideoMultiStepProgress(new float[]{0.45f, 0.1f, 0.45f}, listener);
                stepProgress.setCurrentStep(0);
                float bitrateMultiple = (float)(frameCount - keyFrameCount) / (float)keyFrameCount + 1.0f;
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                retriever.setDataSource(input);
                int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
                int duration = Integer.parseInt(retriever.extractMetadata(9));
                try {
                    VideoProcessor.processVideo(context, input, tempFile.getAbsolutePath(), null, null, null, null, null, (int)((float)oriBitrate * bitrateMultiple), null, 0, stepProgress);
                }
                catch (MediaCodec.CodecException e) {
                    CL.e(e);
                    VideoProcessor.processVideo(context, input, tempFile.getAbsolutePath(), null, null, null, null, null, (int)((float)oriBitrate * bitrateMultiple), null, -1, stepProgress);
                }
                stepProgress.setCurrentStep(1);
                VideoProcessor.reverseVideoNoDecode(tempFile.getAbsolutePath(), temp2File.getAbsolutePath(), stepProgress);
                int oriIFrameInterval = (int)((float)keyFrameCount / ((float)duration / 1000.0f));
                oriIFrameInterval = oriIFrameInterval == 0 ? 1 : oriIFrameInterval;
                stepProgress.setCurrentStep(2);
                VideoProcessor.processVideo(context, temp2File.getAbsolutePath(), output, null, null, null, null, null, oriBitrate, null, oriIFrameInterval, stepProgress);
            }
            finally {
                tempFile.delete();
                temp2File.delete();
            }
        }
    }

    public static void processVideo(Context context, String input, String output, @Nullable Integer outWidth, @Nullable Integer outHeight, @Nullable Integer startTimeMs, @Nullable Integer endTimeMs, @Nullable Float speed, @Nullable Integer bitrate, @Nullable Integer frameRate, @Nullable Integer iFrameInterval, @Nullable VideoProgressListener listener) throws Exception {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int originWidth = Integer.parseInt(retriever.extractMetadata(18));
        int originHeight = Integer.parseInt(retriever.extractMetadata(19));
        int rotationValue = Integer.parseInt(retriever.extractMetadata(24));
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        int duration = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        if (bitrate == null) {
            bitrate = oriBitrate;
        }
        if (iFrameInterval == null) {
            iFrameInterval = 1;
        }
        int resultWidth = outWidth == null ? originWidth : outWidth;
        int resultHeight = outHeight == null ? originHeight : outHeight;
        resultWidth = resultWidth % 2 == 0 ? resultWidth : resultWidth + 1;
        int n = resultHeight = resultHeight % 2 == 0 ? resultHeight : resultHeight + 1;
        if (rotationValue == 90 || rotationValue == 270) {
            int temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
        }
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoIndex = VideoUtil.selectTrack(extractor, false);
        int audioIndex = VideoUtil.selectTrack(extractor, true);
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        int muxerAudioTrackIndex = 0;
        if (audioIndex >= 0) {
            MediaFormat audioTrackFormat = extractor.getTrackFormat(audioIndex);
            if (startTimeMs != null || endTimeMs != null || speed != null) {
                long durationUs = audioTrackFormat.getLong("durationUs");
                if (startTimeMs != null && endTimeMs != null) {
                    durationUs = (endTimeMs - startTimeMs) * 1000;
                }
                if (speed != null) {
                    durationUs = (long)((float)durationUs / speed.floatValue());
                }
                audioTrackFormat.setLong("durationUs", durationUs);
            }
            muxerAudioTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
        }
        extractor.selectTrack(videoIndex);
        if (startTimeMs != null) {
            extractor.seekTo((long)(startTimeMs * 1000), 0);
        } else {
            extractor.seekTo(0L, 0);
        }
        VideoProgressAve progressAve = new VideoProgressAve(listener);
        progressAve.setSpeed(speed);
        progressAve.setStartTimeMs(startTimeMs == null ? 0 : startTimeMs);
        progressAve.setEndTimeMs(endTimeMs == null ? duration : endTimeMs);
        AtomicBoolean decodeDone = new AtomicBoolean(false);
        CountDownLatch muxerStartLatch = new CountDownLatch(1);
        VideoEncodeThread encodeThread = new VideoEncodeThread(extractor, mediaMuxer, bitrate, resultWidth, resultHeight, iFrameInterval, frameRate == null ? DEFAULT_FRAME_RATE : frameRate, videoIndex, decodeDone, muxerStartLatch);
        int srcFrameRate = VideoUtil.getFrameRate(input);
        if (srcFrameRate <= 0) {
            srcFrameRate = (int)Math.ceil(VideoUtil.getAveFrameRate(input));
        }
        VideoDecodeThread decodeThread = new VideoDecodeThread(encodeThread, extractor, startTimeMs, endTimeMs, srcFrameRate, frameRate == null ? DEFAULT_FRAME_RATE : frameRate, speed, videoIndex, decodeDone);
        AudioProcessThread audioProcessThread = new AudioProcessThread(context, input, mediaMuxer, startTimeMs, endTimeMs, speed, muxerAudioTrackIndex, muxerStartLatch);
        encodeThread.setProgressAve(progressAve);
        audioProcessThread.setProgressAve(progressAve);
        decodeThread.start();
        encodeThread.start();
        audioProcessThread.start();
        try {
            long s = System.currentTimeMillis();
            decodeThread.join();
            encodeThread.join();
            long e1 = System.currentTimeMillis();
            audioProcessThread.join();
            long e2 = System.currentTimeMillis();
            CL.w(String.format("\u7f16\u89e3\u7801:%dms,\u97f3\u9891:%dms", e1 - s, e2 - s), new Object[0]);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            mediaMuxer.release();
            extractor.release();
        }
        catch (Exception e2) {
            CL.e(e2);
        }
        if (encodeThread.getException() != null) {
            throw encodeThread.getException();
        }
        if (decodeThread.getException() != null) {
            throw decodeThread.getException();
        }
        if (audioProcessThread.getException() != null) {
            throw audioProcessThread.getException();
        }
    }

    public static void reverseVideoNoDecode(String input, String output) throws IOException {
        VideoProcessor.reverseVideoNoDecode(input, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseVideoNoDecode(String input, String output, @Nullable VideoProgressListener listener) throws IOException {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int durationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoTrackIndex = VideoUtil.selectTrack(extractor, false);
        int audioTrackIndex = VideoUtil.selectTrack(extractor, true);
        boolean audioExist = audioTrackIndex >= 0;
        int MIN_FRAME_INTERVAL = 10000;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        extractor.selectTrack(videoTrackIndex);
        MediaFormat videoTrackFormat = extractor.getTrackFormat(videoTrackIndex);
        long videoDurationUs = videoTrackFormat.getLong("durationUs");
        long audioDurationUs = 0L;
        int videoMuxerTrackIndex = mediaMuxer.addTrack(videoTrackFormat);
        int audioMuxerTrackIndex = 0;
        if (audioExist) {
            MediaFormat audioTrackFormat = extractor.getTrackFormat(audioTrackIndex);
            audioMuxerTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
            audioDurationUs = audioTrackFormat.getLong("durationUs");
        }
        mediaMuxer.start();
        int maxBufferSize = videoTrackFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        VideoUtil.seekToLastFrame(extractor, videoTrackIndex, durationMs);
        long lastFrameTimeUs = -1L;
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        try {
            long seekTime;
            long sampleTime;
            while (true) {
                sampleTime = extractor.getSampleTime();
                if (lastFrameTimeUs == -1L) {
                    lastFrameTimeUs = sampleTime;
                }
                info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                info.size = extractor.readSampleData(buffer, 0);
                info.flags = extractor.getSampleFlags();
                if (info.size < 0) break;
                mediaMuxer.writeSampleData(videoMuxerTrackIndex, buffer, info);
                if (listener != null) {
                    float videoProgress = (float)info.presentationTimeUs / (float)videoDurationUs;
                    videoProgress = videoProgress > 1.0f ? 1.0f : videoProgress;
                    listener.onProgress(videoProgress *= 0.7f);
                }
                if ((seekTime = sampleTime - 10000L) <= 0L) break;
                extractor.seekTo(seekTime, 0);
            }
            if (audioExist) {
                extractor.unselectTrack(videoTrackIndex);
                extractor.selectTrack(audioTrackIndex);
                VideoUtil.seekToLastFrame(extractor, audioTrackIndex, durationMs);
                lastFrameTimeUs = -1L;
                while (true) {
                    sampleTime = extractor.getSampleTime();
                    if (lastFrameTimeUs == -1L) {
                        lastFrameTimeUs = sampleTime;
                    }
                    info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                    info.size = extractor.readSampleData(buffer, 0);
                    info.flags = extractor.getSampleFlags();
                    if (info.size < 0) break;
                    mediaMuxer.writeSampleData(audioMuxerTrackIndex, buffer, info);
                    if (listener != null) {
                        float audioProgress = (float)info.presentationTimeUs / (float)audioDurationUs;
                        audioProgress = audioProgress > 1.0f ? 1.0f : audioProgress;
                        audioProgress = 0.7f + audioProgress * 0.3f;
                        listener.onProgress(audioProgress);
                    }
                    if ((seekTime = sampleTime - 10000L) <= 0L) break;
                    extractor.seekTo(seekTime, 0);
                }
            }
            if (listener != null) {
                listener.onProgress(1.0f);
            }
        }
        finally {
            extractor.release();
            mediaMuxer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixAudioTrack(Context context, final String videoInput, final String aacInput, String output, Integer startTimeMs, Integer endTimeMs, @IntRange(from=0L, to=100L) int videoVolume, @IntRange(from=0L, to=100L) int aacVolume, float fadeInSec, float fadeOutSec) throws IOException {
        File wavFile;
        File adjustedPcm;
        int sampleRate;
        int channelCount;
        int muxerAudioIndex;
        int audioBitrate;
        int videoDurationMs;
        MediaMetadataRetriever retriever;
        Integer endTimeUs;
        File cacheDir = new File(context.getCacheDir(), "pcm");
        cacheDir.mkdir();
        final File videoPcmFile = new File(cacheDir, "video_" + System.currentTimeMillis() + ".pcm");
        File aacPcmFile = new File(cacheDir, "aac_" + System.currentTimeMillis() + ".pcm");
        final Integer startTimeUs = startTimeMs == null ? 0 : startTimeMs * 1000;
        Integer n = endTimeUs = endTimeMs == null ? null : Integer.valueOf(endTimeMs * 1000);
        if (endTimeUs == null) {
            retriever = new MediaMetadataRetriever();
            retriever.setDataSource(videoInput);
            videoDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        } else {
            videoDurationMs = (endTimeUs - startTimeUs) / 1000;
        }
        retriever = new MediaMetadataRetriever();
        retriever.setDataSource(aacInput);
        final int aacDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        MediaExtractor oriExtrator = new MediaExtractor();
        oriExtrator.setDataSource(videoInput);
        int oriAudioIndex = VideoUtil.selectTrack(oriExtrator, true);
        MediaExtractor aacExtractor = new MediaExtractor();
        aacExtractor.setDataSource(aacInput);
        int aacAudioIndex = VideoUtil.selectTrack(aacExtractor, true);
        int TIMEOUT_US = 2500;
        int oriVideoIndex = VideoUtil.selectTrack(oriExtrator, false);
        MediaFormat oriVideoFormat = oriExtrator.getTrackFormat(oriVideoIndex);
        int rotation = oriVideoFormat.containsKey("rotation-degrees") ? oriVideoFormat.getInteger("rotation-degrees") : 0;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        mediaMuxer.setOrientationHint(rotation);
        int muxerVideoIndex = mediaMuxer.addTrack(oriVideoFormat);
        if (oriAudioIndex >= 0) {
            long s1 = System.currentTimeMillis();
            final CountDownLatch latch = new CountDownLatch(2);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AudioUtil.decodeToPCM(videoInput, videoPcmFile.getAbsolutePath(), startTimeUs, endTimeUs);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
            final File finalAacPcmFile = aacPcmFile;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AudioUtil.decodeToPCM(aacInput, finalAacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long s2 = System.currentTimeMillis();
            MediaFormat oriAudioFormat = oriExtrator.getTrackFormat(oriAudioIndex);
            audioBitrate = AudioUtil.getAudioBitrate(oriAudioFormat);
            muxerAudioIndex = mediaMuxer.addTrack(oriAudioFormat);
            Pair<Integer, Integer> resultPair = AudioUtil.checkAndAdjustAudioFormat(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), oriExtrator.getTrackFormat(oriAudioIndex), aacExtractor.getTrackFormat(aacAudioIndex));
            channelCount = (Integer)resultPair.first;
            sampleRate = (Integer)resultPair.second;
            aacExtractor.release();
            long s3 = System.currentTimeMillis();
            if (AUDIO_MIX_REPEAT) {
                aacPcmFile = AudioUtil.checkAndFillPcm(aacPcmFile, aacDurationMs, videoDurationMs);
            }
            adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
            AudioUtil.mixPcm(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), videoVolume, aacVolume);
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            long s4 = System.currentTimeMillis();
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            if (fadeInSec != 0.0f || fadeOutSec != 0.0f) {
                AudioFadeUtil.audioFade(adjustedPcm.getAbsolutePath(), sampleRate, channelCount, fadeInSec, fadeOutSec);
            }
            new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
            long s5 = System.currentTimeMillis();
            CL.et("hwLog", String.format("decode:%dms,resample:%dms,mix:%dms,fade:%dms", s2 - s1, s3 - s2, s4 - s3, s5 - s4), new Object[0]);
        } else {
            AudioUtil.decodeToPCM(aacInput, aacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
            MediaFormat aacTrackFormat = aacExtractor.getTrackFormat(aacAudioIndex);
            audioBitrate = AudioUtil.getAudioBitrate(aacTrackFormat);
            muxerAudioIndex = mediaMuxer.addTrack(aacTrackFormat);
            sampleRate = aacTrackFormat.getInteger("sample-rate");
            int n2 = channelCount = aacTrackFormat.containsKey("channel-count") ? aacTrackFormat.getInteger("channel-count") : 1;
            if (channelCount > 2) {
                File tempFile = new File(aacPcmFile + ".channel");
                AudioUtil.stereoToMonoSimple(aacPcmFile.getAbsolutePath(), tempFile.getAbsolutePath(), channelCount);
                channelCount = 1;
                aacPcmFile.delete();
                aacPcmFile = tempFile;
            }
            if (aacVolume != 50) {
                adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
                AudioUtil.adjustPcmVolume(aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), aacVolume);
            } else {
                adjustedPcm = aacPcmFile;
            }
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            if (fadeInSec != 0.0f || fadeOutSec != 0.0f) {
                AudioFadeUtil.audioFade(adjustedPcm.getAbsolutePath(), sampleRate, channelCount, fadeInSec, fadeOutSec);
            }
            new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
        }
        mediaMuxer.start();
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(wavFile.getAbsolutePath());
        int audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        int maxBufferSize = AudioUtil.getAudioMaxBufferSize(pcmTrackFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", audioBitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        boolean encodeDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            long sampleTimeUs;
            block9: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block9;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = false;
                    }
                    if (info.flags != 2) {
                        lastAudioFrameTimeUs = info.presentationTimeUs;
                    }
                    mediaMuxer.writeSampleData(muxerAudioIndex, encodeOutputBuffer, info);
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
            if (oriAudioIndex >= 0) {
                oriExtrator.unselectTrack(oriAudioIndex);
            }
            oriExtrator.selectTrack(oriVideoIndex);
            oriExtrator.seekTo((long)startTimeUs.intValue(), 0);
            maxBufferSize = oriVideoFormat.getInteger("max-input-size");
            int frameRate = oriVideoFormat.containsKey("frame-rate") ? oriVideoFormat.getInteger("frame-rate") : (int)Math.ceil(VideoUtil.getAveFrameRate(videoInput));
            buffer = ByteBuffer.allocateDirect(maxBufferSize);
            int VIDEO_FRAME_TIME_US = (int)(1000000.0f / (float)frameRate);
            long lastVideoFrameTimeUs = -1L;
            detectTimeError = false;
            while ((sampleTimeUs = oriExtrator.getSampleTime()) != -1L) {
                if (sampleTimeUs < (long)startTimeUs.intValue()) {
                    oriExtrator.advance();
                    continue;
                }
                if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                    break;
                }
                info.presentationTimeUs = sampleTimeUs - (long)startTimeUs.intValue();
                info.flags = oriExtrator.getSampleFlags();
                info.size = oriExtrator.readSampleData(buffer, 0);
                if (info.size < 0) {
                    break;
                }
                if (!detectTimeError && lastVideoFrameTimeUs != -1L && info.presentationTimeUs < lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US) {
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0clastVideoFrameTimeUs:" + lastVideoFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs + " VIDEO_FRAME_TIME_US:" + VIDEO_FRAME_TIME_US, new Object[0]);
                    detectTimeError = true;
                }
                if (detectTimeError) {
                    info.presentationTimeUs = lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US;
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                    detectTimeError = false;
                }
                if (info.flags != 2) {
                    lastVideoFrameTimeUs = info.presentationTimeUs;
                }
                CL.wt(TAG, "video writeSampleData:" + info.presentationTimeUs + " type:" + info.flags + " size:" + info.size, new Object[0]);
                mediaMuxer.writeSampleData(muxerVideoIndex, buffer, info);
                oriExtrator.advance();
            }
        }
        finally {
            aacPcmFile.delete();
            videoPcmFile.delete();
            adjustedPcm.delete();
            wavFile.delete();
            try {
                pcmExtrator.release();
                oriExtrator.release();
                mediaMuxer.release();
                encoder.stop();
                encoder.release();
            }
            catch (Exception e) {
                CL.e(e);
            }
        }
    }

    public static Processor processor(Context context) {
        return new Processor(context);
    }

    public static class Processor {
        private Context context;
        private String input;
        private String output;
        @Nullable
        private Integer outWidth;
        @Nullable
        private Integer outHeight;
        @Nullable
        private Integer startTimeMs;
        @Nullable
        private Integer endTimeMs;
        @Nullable
        private Float speed;
        @Nullable
        private Integer bitrate;
        @Nullable
        private Integer frameRate;
        @Nullable
        private Integer iFrameInterval;
        @Nullable
        private VideoProgressListener listener;

        public Processor(Context context) {
            this.context = context;
        }

        public Processor input(String input) {
            this.input = input;
            return this;
        }

        public Processor output(String output) {
            this.output = output;
            return this;
        }

        public Processor outWidth(int outWidth) {
            this.outWidth = outWidth;
            return this;
        }

        public Processor outHeight(int outHeight) {
            this.outHeight = outHeight;
            return this;
        }

        public Processor startTimeMs(int startTimeMs) {
            this.startTimeMs = startTimeMs;
            return this;
        }

        public Processor endTimeMs(int endTimeMs) {
            this.endTimeMs = endTimeMs;
            return this;
        }

        public Processor speed(float speed) {
            this.speed = Float.valueOf(speed);
            return this;
        }

        public Processor bitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public Processor frameRate(int frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public Processor iFrameInterval(int iFrameInterval) {
            this.iFrameInterval = iFrameInterval;
            return this;
        }

        public Processor progressListener(VideoProgressListener listener) {
            this.listener = listener;
            return this;
        }

        public void process() throws Exception {
            VideoProcessor.processVideo(this.context, this.input, this.output, this.outWidth, this.outHeight, this.startTimeMs, this.endTimeMs, this.speed, this.bitrate, this.frameRate, this.iFrameInterval, this.listener);
        }
    }
}

