/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.VideoProgressListener;

public class VideoProgressAve {
    private VideoProgressListener mListener;
    private float mEncodeProgress;
    private float mAudioProgress;
    private int mStartTimeMs;
    private int mEndTimeMs;
    private Float mSpeed;

    public VideoProgressAve(VideoProgressListener listener) {
        this.mListener = listener;
    }

    public void setEncodeTimeStamp(long timeStampUs) {
        if (this.mListener == null) {
            return;
        }
        if (this.mSpeed != null) {
            timeStampUs = (long)((float)timeStampUs * this.mSpeed.floatValue());
        }
        this.mEncodeProgress = ((float)timeStampUs / 1000.0f - (float)this.mStartTimeMs) / (float)(this.mEndTimeMs - this.mStartTimeMs);
        this.mEncodeProgress = this.mEncodeProgress < 0.0f ? 0.0f : this.mEncodeProgress;
        this.mEncodeProgress = this.mEncodeProgress > 1.0f ? 1.0f : this.mEncodeProgress;
        this.mListener.onProgress((this.mEncodeProgress + this.mAudioProgress) / 2.0f);
        CL.i("mEncodeProgress:" + this.mEncodeProgress, new Object[0]);
    }

    public void setAudioProgress(float audioProgress) {
        this.mAudioProgress = audioProgress;
        if (this.mListener != null) {
            this.mListener.onProgress((this.mEncodeProgress + this.mAudioProgress) / 2.0f);
        }
        CL.i("mAudioProgress:" + this.mAudioProgress, new Object[0]);
    }

    public void setStartTimeMs(int startTimeMs) {
        this.mStartTimeMs = startTimeMs;
    }

    public void setEndTimeMs(int endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public void setSpeed(Float speed) {
        this.mSpeed = speed;
    }
}

