/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import com.hw.videoprocessor.util.VideoProgressListener;

public class VideoMultiStepProgress
implements VideoProgressListener {
    private float[] mStepPercentes;
    private int mCurrentStep;
    private VideoProgressListener mListener;
    private float mStepBaseProgress;

    public VideoMultiStepProgress(float[] stepPercents, VideoProgressListener listener) {
        this.mStepPercentes = stepPercents;
        this.mListener = listener;
    }

    public void setCurrentStep(int stepIndex) {
        this.mCurrentStep = stepIndex;
        this.mStepBaseProgress = 0.0f;
        for (int i = 0; i < stepIndex; ++i) {
            this.mStepBaseProgress += this.mStepPercentes[i];
        }
    }

    @Override
    public void onProgress(float progress) {
        if (this.mListener != null) {
            float totalProgress = progress * this.mStepPercentes[this.mCurrentStep] + this.mStepBaseProgress;
            this.mListener.onProgress(totalProgress);
        }
    }

    public void setListener(VideoProgressListener listener) {
        this.mListener = listener;
    }
}

