/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaMetadataRetriever;
import com.hw.videoprocessor.VideoProcessor;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.CL;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class VideoEffects {
    public static void doKichiku(Context context, String inputVideo, String outputVideo, float speed, int splitTimeMs) throws IOException {
        List<File> fileList;
        File cacheDir = new File(context.getCacheDir(), "kichiku_" + System.currentTimeMillis());
        cacheDir.mkdir();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(inputVideo);
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        retriever.release();
        File speedVideo = new File(cacheDir, "speed_" + speed + ".tmp");
        VideoProcessor.processVideo(context, inputVideo, speedVideo.getAbsolutePath(), null, null, null, null, Float.valueOf(speed), null, null);
        int bitrate = VideoUtil.getBitrateForAllKeyFrameVideo(inputVideo);
        try {
            fileList = VideoUtil.splitVideo(context, speedVideo.getAbsolutePath(), cacheDir.getAbsolutePath(), splitTimeMs, 500, bitrate, 0);
        }
        catch (MediaCodec.CodecException e) {
            CL.e(e);
            fileList = VideoUtil.splitVideo(context, speedVideo.getAbsolutePath(), cacheDir.getAbsolutePath(), splitTimeMs, 500, bitrate, -1);
        }
        File cacheCombineFile = new File(cacheDir, "combine_" + System.currentTimeMillis() + ".tmp");
        VideoUtil.combineVideos(fileList, cacheCombineFile.getAbsolutePath());
        VideoProcessor.processVideo(context, cacheCombineFile.getAbsolutePath(), outputVideo, null, null, null, null, null, oriBitrate, 1);
        cacheCombineFile.delete();
    }
}

