/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.support.annotation.IntRange;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class AudioUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustPcmVolumn(String fromPath, String toPath, @IntRange(from=0L, to=100L) int volumn) throws IOException {
        float vol = AudioUtil.normalizeVolumn(volumn);
        byte[] buffer = new byte[2048];
        FileInputStream fileInputStream = new FileInputStream(fromPath);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        try {
            while (fileInputStream.read(buffer) != -1) {
                for (int i = 0; i < buffer.length; i += 2) {
                    int tmp = buffer[i] & 0xFF | (buffer[i + 1] & 0xFF) << 8;
                    if ((tmp = (int)((float)tmp * vol)) > Short.MAX_VALUE) {
                        tmp = Short.MAX_VALUE;
                    } else if (tmp < Short.MIN_VALUE) {
                        tmp = Short.MIN_VALUE;
                    }
                    buffer[i] = (byte)(tmp & 0xFF);
                    buffer[i + 1] = (byte)(tmp >>> 8 & 0xFF);
                }
                fileOutputStream.write(buffer);
            }
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    private static float normalizeVolumn(@IntRange(from=0L, to=100L) int volumn) {
        if (volumn <= 50) {
            return (float)volumn / 50.0f;
        }
        return (float)(volumn - 50) / 50.0f * 39.0f + 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixPcm(String pcm1Path, String pcm2Path, String toPath, @IntRange(from=0L, to=100L) int volumn1, @IntRange(from=0L, to=100L) int volumn2) throws IOException {
        float vol1 = AudioUtil.normalizeVolumn(volumn1);
        float vol2 = AudioUtil.normalizeVolumn(volumn2);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[2048];
        byte[] buffer3 = new byte[2048];
        FileInputStream is1 = new FileInputStream(pcm1Path);
        FileInputStream is2 = new FileInputStream(pcm2Path);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        boolean end1 = false;
        boolean end2 = false;
        try {
            while (!end1 || !end2) {
                if (!end1) {
                    end1 = is1.read(buffer1) == -1;
                    System.arraycopy(buffer1, 0, buffer3, 0, buffer1.length);
                }
                if (!end2) {
                    end2 = is2.read(buffer2) == -1;
                    for (int i = 0; i < buffer2.length; i += 2) {
                        short temp2 = (short)(buffer2[i] & 0xFF | (buffer2[i + 1] & 0xFF) << 8);
                        short temp1 = (short)(buffer1[i] & 0xFF | (buffer1[i + 1] & 0xFF) << 8);
                        int temp = (int)((float)temp2 * vol2 + (float)temp1 * vol1);
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        } else if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffer3[i] = (byte)(temp & 0xFF);
                        buffer3[i + 1] = (byte)(temp >>> 8 & 0xFF);
                    }
                }
                fileOutputStream.write(buffer3);
            }
        }
        finally {
            is1.close();
            is2.close();
            fileOutputStream.close();
        }
    }

    public static void stereoToMono(String from, String to) throws IOException {
        FileInputStream is = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[1024];
        while (is.read(buffer1) != -1) {
            for (int i = 0; i < buffer2.length; i += 2) {
                buffer2[i] = buffer1[2 * i];
                buffer2[i + 1] = buffer1[2 * i + 1];
            }
            os.write(buffer2);
        }
        is.close();
        os.close();
    }

    public static void copyFile(String from, String to) throws IOException {
        FileChannel toChannel = new FileOutputStream(to).getChannel();
        FileChannel fromChannel = new FileInputStream(from).getChannel();
        fromChannel.transferTo(0L, fromChannel.size(), toChannel);
    }

    public static boolean isStereo(String aacPath) throws IOException {
        String mime;
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(aacPath);
        MediaFormat format = null;
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks && !(mime = (format = extractor.getTrackFormat(i)).getString("mime")).startsWith("audio/"); ++i) {
        }
        extractor.release();
        if (format == null) {
            return false;
        }
        return format.getInteger("channel-count") > 1;
    }
}

