/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import android.media.AudioRecord;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PcmToWavUtil {
    private int mBufferSize;
    private int mSampleRate = 8000;
    private int mChannel = 12;
    private int mEncoding = 2;

    public PcmToWavUtil() {
        this.mBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)this.mChannel, (int)this.mEncoding);
    }

    public PcmToWavUtil(int sampleRate, int channel, int encoding) {
        this.mSampleRate = sampleRate;
        this.mChannel = channel;
        this.mEncoding = encoding;
        this.mBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)this.mChannel, (int)this.mEncoding);
    }

    public void pcmToWav(String inFilename, String outFilename) {
        long longSampleRate = this.mSampleRate;
        int channels = 2;
        long byteRate = 16 * this.mSampleRate * channels / 8;
        byte[] data = new byte[this.mBufferSize];
        try {
            FileInputStream in = new FileInputStream(inFilename);
            FileOutputStream out = new FileOutputStream(outFilename);
            long totalAudioLen = in.getChannel().size();
            long totalDataLen = totalAudioLen + 36L;
            this.writeWaveFileHeader(out, totalAudioLen, totalDataLen, longSampleRate, channels, byteRate);
            while (in.read(data) != -1) {
                out.write(data);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeWaveFileHeader(FileOutputStream out, long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate) throws IOException {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), 4, 0, 16, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        out.write(header, 0, 44);
    }
}

