/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.InputSurface;
import com.hw.videoprocessor.util.OutputSurface;
import com.hw.videoprocessor.util.PcmToWavUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.surina.soundtouch.SoundTouch;

@TargetApi(value=21)
public class VideoProcessor {
    private static final String TAG = "VideoProcessor";
    private static final String MIME_TYPE = "video/avc";
    public static final int DEFAULT_FRAME_RATE = 25;
    public static final int DEFAULT_I_FRAME_INTERVAL = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processVideo(Context context, String input, String output, @Nullable Integer outWidth, @Nullable Integer outHeight, @Nullable Integer startTimeMs, @Nullable Integer endTimeMs, @Nullable Float speed, @Nullable Integer bitrate) throws IOException {
        int resultHeight;
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int originWidth = Integer.parseInt(retriever.extractMetadata(18));
        int originHeight = Integer.parseInt(retriever.extractMetadata(19));
        int rotationValue = Integer.parseInt(retriever.extractMetadata(24));
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        int resultWidth = outWidth == null ? originWidth : outWidth;
        int n = resultHeight = outHeight == null ? originHeight : outHeight;
        if (rotationValue == 90 || rotationValue == 270) {
            int temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
        }
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoIndex = VideoProcessor.selectTrack(extractor, false);
        int audioIndex = VideoProcessor.selectTrack(extractor, true);
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        MediaFormat audioTrackFormat = extractor.getTrackFormat(audioIndex);
        if (startTimeMs != null || endTimeMs != null || speed != null) {
            long durationUs = audioTrackFormat.getLong("durationUs");
            if (startTimeMs != null && endTimeMs != null) {
                durationUs = (endTimeMs - startTimeMs) * 1000;
            }
            if (speed != null) {
                durationUs = (long)((float)durationUs / speed.floatValue());
            }
            audioTrackFormat.setLong("durationUs", durationUs);
        }
        int muxerAudioTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
        extractor.selectTrack(videoIndex);
        if (startTimeMs != null) {
            extractor.seekTo((long)(startTimeMs * 1000), 0);
        } else {
            extractor.seekTo(0L, 0);
        }
        MediaCodec decoder = null;
        MediaCodec encoder = null;
        MediaFormat outputFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)resultWidth, (int)resultHeight);
        outputFormat.setInteger("color-format", 2130708361);
        outputFormat.setInteger("bitrate", bitrate == null ? oriBitrate : bitrate);
        outputFormat.setInteger("frame-rate", 25);
        outputFormat.setInteger("i-frame-interval", 0);
        encoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
        encoder.configure(outputFormat, null, null, 1);
        Surface surface = encoder.createInputSurface();
        InputSurface inputSurface = new InputSurface(surface);
        inputSurface.makeCurrent();
        MediaFormat inputFormat = extractor.getTrackFormat(videoIndex);
        decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        inputFormat.setInteger("color-format", 2130708361);
        OutputSurface outputSurface = new OutputSurface();
        decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
        decoder.start();
        encoder.start();
        int TIMEOUT_USEC = 2500;
        long videoStartTimeUs = -1L;
        try {
            Integer endTimeUs;
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            boolean encoderDone = false;
            boolean decoderDone = false;
            boolean inputDone = false;
            boolean signalEncodeEnd = false;
            int videoTrackIndex = -5;
            block7: while (!decoderDone || !encoderDone) {
                boolean encoderOutputAvailable;
                boolean decoderOutputAvailable;
                if (!inputDone) {
                    int inputBufIndex;
                    boolean eof = false;
                    int index = extractor.getSampleTrackIndex();
                    if (index == videoIndex) {
                        inputBufIndex = decoder.dequeueInputBuffer(2500L);
                        if (inputBufIndex >= 0) {
                            ByteBuffer inputBuf = decoder.getInputBuffer(inputBufIndex);
                            int chunkSize = extractor.readSampleData(inputBuf, 0);
                            if (chunkSize < 0) {
                                decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                decoderDone = true;
                            } else {
                                long sampleTime = extractor.getSampleTime();
                                decoder.queueInputBuffer(inputBufIndex, 0, chunkSize, sampleTime, 0);
                                extractor.advance();
                            }
                        }
                    } else if (index == -1) {
                        eof = true;
                    }
                    if (eof) {
                        CL.it(TAG, "inputDone", new Object[0]);
                        inputBufIndex = decoder.dequeueInputBuffer(2500L);
                        if (inputBufIndex >= 0) {
                            decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                }
                boolean bl = decoderOutputAvailable = !decoderDone;
                if (decoderDone) {
                    CL.it(TAG, "decoderOutputAvailable:" + decoderOutputAvailable, new Object[0]);
                }
                while (decoderOutputAvailable) {
                    int outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L);
                    CL.it(TAG, "outputBufferIndex = " + outputBufferIndex, new Object[0]);
                    if (outputBufferIndex == -1) break;
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = decoder.getOutputFormat();
                        CL.it(TAG, "decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    boolean doRender = true;
                    if (endTimeMs != null && info.presentationTimeUs >= (long)(endTimeMs * 1000)) {
                        inputDone = true;
                        decoderDone = true;
                        doRender = false;
                        info.flags |= 4;
                    }
                    if (startTimeMs != null && info.presentationTimeUs < (long)(startTimeMs * 1000)) {
                        doRender = false;
                        CL.et(TAG, "drop frame startTime = " + startTimeMs + " present time = " + info.presentationTimeUs / 1000L, new Object[0]);
                    }
                    if (info.flags == 4) {
                        decoderDone = true;
                        decoder.releaseOutputBuffer(outputBufferIndex, false);
                        CL.it(TAG, "decoderDone", new Object[0]);
                        break;
                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, true);
                    if (!doRender) continue;
                    boolean errorWait = false;
                    try {
                        outputSurface.awaitNewImage();
                    }
                    catch (Exception e) {
                        errorWait = true;
                        CL.et(TAG, e.getMessage(), new Object[0]);
                    }
                    if (errorWait) continue;
                    if (videoStartTimeUs == -1L) {
                        videoStartTimeUs = info.presentationTimeUs;
                        CL.it(TAG, "videoStartTime:" + videoStartTimeUs / 1000L, new Object[0]);
                    }
                    outputSurface.drawImage(false);
                    long presentationTimeNs = (info.presentationTimeUs - videoStartTimeUs) * 1000L;
                    if (speed != null) {
                        presentationTimeNs = (long)((float)presentationTimeNs / speed.floatValue());
                    }
                    inputSurface.setPresentationTime(presentationTimeNs);
                    inputSurface.swapBuffers();
                    break;
                }
                if (decoderDone && !signalEncodeEnd) {
                    signalEncodeEnd = true;
                    encoder.signalEndOfInputStream();
                }
                boolean bl2 = encoderOutputAvailable = !encoderDone;
                while (encoderOutputAvailable) {
                    int outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L);
                    CL.it(TAG, "encode outputBufferIndex = " + outputBufferIndex, new Object[0]);
                    if (outputBufferIndex == -1) continue block7;
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        if (videoTrackIndex == -5) {
                            videoTrackIndex = mediaMuxer.addTrack(newFormat);
                            mediaMuxer.start();
                        }
                        CL.it(TAG, "encode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    ByteBuffer outputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    mediaMuxer.writeSampleData(videoTrackIndex, outputBuffer, info);
                    CL.it(TAG, "writeSampleData,size:" + info.size + " time:" + info.presentationTimeUs / 1000L, new Object[0]);
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                    if (info.flags != 4) continue;
                    encoderDone = true;
                    CL.it(TAG, "encoderDone", new Object[0]);
                    continue block7;
                }
            }
            encoder.stop();
            decoder.stop();
            extractor.unselectTrack(videoIndex);
            Integer startTimeUs = startTimeMs == null ? null : Integer.valueOf((int)videoStartTimeUs);
            Integer n2 = endTimeUs = endTimeMs == null ? null : Integer.valueOf(endTimeMs * 1000);
            if (speed != null) {
                VideoProcessor.writeAudioTrack(context, extractor, mediaMuxer, muxerAudioTrackIndex, startTimeUs, endTimeUs, speed);
            } else {
                VideoProcessor.writeAudioTrack(extractor, mediaMuxer, muxerAudioTrackIndex, startTimeUs, endTimeUs);
            }
        }
        catch (Exception e) {
            CL.e(e);
        }
        finally {
            mediaMuxer.release();
            encoder.release();
            decoder.release();
            extractor.release();
        }
    }

    private static void writeAudioTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs) throws IOException {
        long sampleTimeUs;
        int audioTrack = VideoProcessor.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat audioFormat = extractor.getTrackFormat(audioTrack);
        int maxBufferSize = audioFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        while ((sampleTimeUs = extractor.getSampleTime()) != -1L) {
            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                extractor.advance();
                continue;
            }
            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) break;
            info.presentationTimeUs = sampleTimeUs - (long)startTimeUs.intValue();
            info.flags = extractor.getSampleFlags();
            info.size = extractor.readSampleData(buffer, 0);
            if (info.size < 0) break;
            mediaMuxer.writeSampleData(muxerAudioTrackIndex, buffer, info);
            extractor.advance();
        }
    }

    private static void writeAudioTrack(Context context, MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs, @NonNull Float speed) throws Exception {
        int audioTrack = VideoProcessor.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);
        int maxBufferSize = oriAudioFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaCodec decoder = MediaCodec.createDecoderByType((String)oriAudioFormat.getString("mime"));
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();
        boolean decodeDone = false;
        boolean encodeDone = false;
        boolean decodeInputDone = false;
        int TIMEOUT_US = 2500;
        File pcmFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".pcm");
        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        while (!decodeDone) {
            int outputBufferIndex;
            if (!decodeInputDone) {
                boolean eof = false;
                int decodeInputIndex = decoder.dequeueInputBuffer(2500L);
                if (decodeInputIndex >= 0) {
                    long sampleTimeUs = extractor.getSampleTime();
                    if (sampleTimeUs == -1L) {
                        eof = true;
                    } else {
                        if (sampleTimeUs < (long)startTimeUs.intValue()) {
                            extractor.advance();
                            continue;
                        }
                        if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                            eof = true;
                        }
                    }
                    if (eof) {
                        decodeInputDone = true;
                        decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0L, 4);
                    } else {
                        info.size = extractor.readSampleData(buffer, 0);
                        info.presentationTimeUs = sampleTimeUs;
                        info.flags = extractor.getSampleFlags();
                        ByteBuffer inputBuffer = decoder.getInputBuffer(decodeInputIndex);
                        inputBuffer.put(buffer);
                        CL.it(TAG, "audio decode queueInputBuffer " + info.presentationTimeUs / 1000L, new Object[0]);
                        decoder.queueInputBuffer(decodeInputIndex, 0, info.size, info.presentationTimeUs, info.flags);
                        extractor.advance();
                    }
                }
            }
            while (!decodeDone && (outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                if (outputBufferIndex == -2) {
                    MediaFormat newFormat = decoder.getOutputFormat();
                    CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                    continue;
                }
                if (outputBufferIndex < 0) {
                    CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                    continue;
                }
                if (info.flags == 4) {
                    decodeDone = true;
                } else {
                    ByteBuffer decodeOutputBuffer = decoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio decode saveFrame " + info.presentationTimeUs / 1000L, new Object[0]);
                    writeChannel.write(decodeOutputBuffer);
                }
                decoder.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
        writeChannel.close();
        int sampleRate = oriAudioFormat.getInteger("sample-rate");
        File wavFile = new File(context.getCacheDir(), pcmFile.getName() + ".wav");
        new PcmToWavUtil(sampleRate, 12, 2).pcmToWav(pcmFile.getAbsolutePath(), wavFile.getAbsolutePath());
        CL.i(TAG, "start process pcm speed");
        File outFile = new File(context.getCacheDir(), pcmFile.getName() + ".outpcm");
        SoundTouch st = new SoundTouch();
        st.setTempo(speed.floatValue());
        int res = st.processFile(wavFile.getAbsolutePath(), outFile.getAbsolutePath());
        if (res < 0) {
            pcmFile.delete();
            wavFile.delete();
            outFile.delete();
            return;
        }
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(outFile.getAbsolutePath());
        audioTrack = VideoProcessor.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        maxBufferSize = pcmExtrator.getTrackFormat(audioTrack).getInteger("max-input-size");
        buffer = ByteBuffer.allocateDirect(maxBufferSize);
        int bitrate = oriAudioFormat.getInteger("bitrate");
        int channelCount = oriAudioFormat.getInteger("channel-count");
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", bitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / (sampleRate * channelCount);
        block2: while (!encodeDone) {
            int outputBufferIndex;
            int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
            if (!encodeInputDone && inputBufferIndex >= 0) {
                long sampleTime = pcmExtrator.getSampleTime();
                if (sampleTime < 0L) {
                    encodeInputDone = true;
                    encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                } else {
                    int flags = pcmExtrator.getSampleFlags();
                    buffer.clear();
                    int size = pcmExtrator.readSampleData(buffer, 0);
                    ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                    inputBuffer.clear();
                    inputBuffer.put(buffer);
                    inputBuffer.position(0);
                    CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                    encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                    pcmExtrator.advance();
                }
            }
            while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                if (outputBufferIndex == -2) {
                    MediaFormat newFormat = encoder.getOutputFormat();
                    CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                    continue;
                }
                if (outputBufferIndex < 0) {
                    CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                    continue;
                }
                if (info.flags == 4) {
                    encodeDone = true;
                    continue block2;
                }
                ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                if (info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                    CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4e22\u5f03,lastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                } else {
                    lastAudioFrameTimeUs = info.presentationTimeUs;
                    mediaMuxer.writeSampleData(muxerAudioTrackIndex, encodeOutputBuffer, info);
                }
                encodeOutputBuffer.clear();
                encoder.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
        pcmFile.delete();
        wavFile.delete();
        outFile.delete();
        Log.e((String)"PCM", (String)("result:" + res + " size:" + outFile.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertVideoWithDecode(Context context, String input, String output) throws IOException {
        File tempFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp");
        try {
            VideoProcessor.processVideo(context, input, tempFile.getAbsolutePath(), null, null, null, null, null, null);
            VideoProcessor.revertVideoNoDecode(tempFile.getAbsolutePath(), output);
        }
        finally {
            tempFile.delete();
        }
    }

    public static void revertVideoNoDecode(String input, String output) throws IOException {
        long seekTime;
        long sampleTime;
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int durationMs = Integer.parseInt(retriever.extractMetadata(9));
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoTrackIndex = VideoProcessor.selectTrack(extractor, false);
        int audioTrackIndex = VideoProcessor.selectTrack(extractor, true);
        int MIN_FRAME_INTERVAL = 10000;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        extractor.selectTrack(videoTrackIndex);
        MediaFormat videoTrackFormat = extractor.getTrackFormat(videoTrackIndex);
        int videoMuxerTrackIndex = mediaMuxer.addTrack(videoTrackFormat);
        MediaFormat audioTrackFormat = extractor.getTrackFormat(audioTrackIndex);
        int audioMuxerTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
        mediaMuxer.start();
        int maxBufferSize = videoTrackFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        extractor.seekTo((long)(durationMs * 1000 + 10000), 0);
        long lastFrameTimeUs = -1L;
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        while (true) {
            sampleTime = extractor.getSampleTime();
            if (lastFrameTimeUs == -1L) {
                lastFrameTimeUs = sampleTime;
            }
            info.presentationTimeUs = lastFrameTimeUs - sampleTime;
            info.size = extractor.readSampleData(buffer, 0);
            info.flags = extractor.getSampleFlags();
            if (info.size < 0) break;
            mediaMuxer.writeSampleData(videoMuxerTrackIndex, buffer, info);
            seekTime = sampleTime - 10000L;
            if (seekTime <= 0L) break;
            extractor.seekTo(seekTime, 0);
        }
        extractor.unselectTrack(videoTrackIndex);
        extractor.selectTrack(audioTrackIndex);
        extractor.seekTo((long)(durationMs * 1000 + 10000), 0);
        lastFrameTimeUs = -1L;
        while (true) {
            sampleTime = extractor.getSampleTime();
            if (lastFrameTimeUs == -1L) {
                lastFrameTimeUs = sampleTime;
            }
            info.presentationTimeUs = lastFrameTimeUs - sampleTime;
            info.size = extractor.readSampleData(buffer, 0);
            info.flags = extractor.getSampleFlags();
            if (info.size < 0) break;
            mediaMuxer.writeSampleData(audioMuxerTrackIndex, buffer, info);
            seekTime = sampleTime - 10000L;
            if (seekTime <= 0L) break;
            extractor.seekTo(seekTime, 0);
        }
        mediaMuxer.stop();
        mediaMuxer.release();
    }

    private static int selectTrack(MediaExtractor extractor, boolean audio) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!(audio ? mime.startsWith("audio/") : mime.startsWith("video/"))) continue;
            return i;
        }
        return -5;
    }
}

