/*
 * Decompiled with CFR 0.152.
 */
package com.appizona.yehiahd.fastsave;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.appizona.yehiahd.fastsave.FastException;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;

public class FastSave {
    private static FastSave instance;
    private static SharedPreferences mSharedPreferences;

    private FastSave() {
    }

    public static void init(Context context) {
        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastSave getInstance() {
        if (instance != null) return instance;
        FastSave.validateInitialization();
        Class<FastSave> clazz = FastSave.class;
        synchronized (FastSave.class) {
            if (instance != null) return instance;
            instance = new FastSave();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void saveInt(String key, int value) {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public int getInt(String key) {
        if (this.isKeyExists(key)) {
            return mSharedPreferences.getInt(key, 0);
        }
        return 0;
    }

    public void saveBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public boolean getBoolean(String key) {
        if (this.isKeyExists(key)) {
            return mSharedPreferences.getBoolean(key, false);
        }
        return false;
    }

    public void saveFloat(String key, float value) {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putFloat(key, value);
        editor.apply();
    }

    public float getFloat(String key) {
        if (this.isKeyExists(key)) {
            return mSharedPreferences.getFloat(key, 0.0f);
        }
        return 0.0f;
    }

    public void saveLong(String key, long value) {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public long getLong(String key) {
        if (this.isKeyExists(key)) {
            return mSharedPreferences.getLong(key, 0L);
        }
        return 0L;
    }

    public void saveString(String key, String value) {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public String getString(String key) {
        if (this.isKeyExists(key)) {
            return mSharedPreferences.getString(key, null);
        }
        return null;
    }

    public <T> void saveObject(String key, T object) {
        String objectString = new Gson().toJson(object);
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putString(key, objectString);
        editor.apply();
    }

    public <T> T getObject(String key, Class<T> classType) {
        String objectString;
        if (this.isKeyExists(key) && (objectString = mSharedPreferences.getString(key, null)) != null) {
            return (T)new Gson().fromJson(objectString, classType);
        }
        return null;
    }

    public <T> void saveObjectsList(String key, List<T> objectList) {
        String objectString = new Gson().toJson(objectList);
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putString(key, objectString);
        editor.apply();
    }

    public <T> List<T> getObjectsList(String key, Class<T> classType) {
        String objectString;
        if (this.isKeyExists(key) && (objectString = mSharedPreferences.getString(key, null)) != null) {
            return (List)new Gson().fromJson(objectString, new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, classType).getType());
        }
        return null;
    }

    public void clearSession() {
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.clear();
        editor.apply();
    }

    public boolean deleteValue(String key) {
        if (this.isKeyExists(key)) {
            SharedPreferences.Editor editor = mSharedPreferences.edit();
            editor.remove(key);
            editor.apply();
            return true;
        }
        return false;
    }

    private static void validateInitialization() {
        if (mSharedPreferences == null) {
            throw new FastException("FastSave Library must be initialized inside your application class by calling FastSave.init(getApplicationContext)");
        }
    }

    public boolean isKeyExists(String key) {
        Map map = mSharedPreferences.getAll();
        if (map.containsKey(key)) {
            return true;
        }
        Log.e((String)"FastSave", (String)("No element founded in sharedPrefs with the key " + key));
        return false;
    }
}

