/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.sprite;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.github.ybq.android.spinkit.sprite.Sprite;
import com.github.ybq.android.spinkit.sprite.SpriteGroup;

public abstract class CircleSpriteGroup
extends SpriteGroup {
    @Override
    public void drawChild(Canvas canvas) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Sprite sprite = this.getChildAt(i);
            int count = canvas.save();
            canvas.rotate((float)(i * 360 / this.getChildCount()), (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            sprite.draw(canvas);
            canvas.restoreToCount(count);
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        bounds = this.clipSquare(bounds);
        int radius = (int)((double)bounds.width() * Math.PI / (double)3.6f / (double)this.getChildCount());
        int left = bounds.centerX() - radius;
        int right = bounds.centerX() + radius;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Sprite sprite = this.getChildAt(i);
            sprite.setDrawBounds(left, bounds.top, right, bounds.top + radius * 2);
        }
    }
}

