/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.util;

import edu.uci.jforests.util.ScoreBasedComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraysUtil {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public static void increment(double[] arr, double inc) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + inc;
        }
    }

    public static int findIndex(int[] arr, int value, int length) {
        for (int i = 0; i < length; ++i) {
            if (arr[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int findMinIndex(double[] arr, int offset, int length) {
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        int endIdx = offset + length;
        for (int i = offset; i < endIdx; ++i) {
            if (!(arr[i] < minValue)) continue;
            minValue = arr[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int findMinIndex(float[] arr, int offset, int length) {
        int minIndex = -1;
        float minValue = Float.MAX_VALUE;
        int endIdx = offset + length;
        for (int i = offset; i < endIdx; ++i) {
            if (!(arr[i] < minValue)) continue;
            minValue = arr[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int findMinIndex(double[] arr) {
        return ArraysUtil.findMinIndex(arr, 0, arr.length);
    }

    public static int findMaxIndex(int[] arr) {
        return ArraysUtil.findMaxIndex(arr, 0, arr.length);
    }

    public static int findMaxIndex(int[] arr, int offset, int length) {
        int maxIndex = -1;
        int maxValue = Integer.MIN_VALUE;
        int endIdx = offset + length;
        for (int i = offset; i < endIdx; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int findMaxIndex(double[] arr) {
        return ArraysUtil.findMaxIndex(arr, 0, arr.length);
    }

    public static int findMaxIndex(double[] arr, int offset, int length) {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        int endIdx = offset + length;
        for (int i = offset; i < endIdx; ++i) {
            if (!(arr[i] > maxValue)) continue;
            maxValue = arr[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int findMaxIndex(float[] arr, int offset, int length) {
        int maxIndex = -1;
        float maxValue = Float.NEGATIVE_INFINITY;
        int endIdx = offset + length;
        for (int i = offset; i < endIdx; ++i) {
            if (!(arr[i] > maxValue)) continue;
            maxValue = arr[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static double getMax(double[] arr, int offset, int length) {
        return arr[ArraysUtil.findMaxIndex(arr, offset, length)];
    }

    public static double getMax(double[] arr, int length) {
        return arr[ArraysUtil.findMaxIndex(arr, 0, length)];
    }

    public static double getMax(double[] arr) {
        return arr[ArraysUtil.findMaxIndex(arr, 0, arr.length)];
    }

    public static double getMin(double[] arr, int offset, int length) {
        return arr[ArraysUtil.findMinIndex(arr, offset, length)];
    }

    public static double getMin(double[] arr, int length) {
        return arr[ArraysUtil.findMinIndex(arr, 0, length)];
    }

    public static double getMin(double[] arr) {
        return arr[ArraysUtil.findMinIndex(arr, 0, arr.length)];
    }

    public static int[] toArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String toTabDelimitedString(double[] arr) {
        StringBuilder sb = new StringBuilder();
        for (double value : arr) {
            sb.append("\t" + value);
        }
        return sb.toString().trim();
    }

    public static String toTabDelimitedString(int[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int value : arr) {
            sb.append("\t" + value);
        }
        return sb.toString().trim();
    }

    public static <T> List<T> getRandomSubset(List<T> fullSet, int size, Random rnd) {
        ArrayList<T> subset = new ArrayList<T>();
        subset.addAll(fullSet);
        while (subset.size() > size) {
            subset.remove(rnd.nextInt(subset.size()));
        }
        return subset;
    }

    public static void insertionSort(int[] arr, ScoreBasedComparator comparator) {
        ArraysUtil.insertionSort(arr, arr.length, comparator);
    }

    public static void insertionSort(int[] arr, int length, ScoreBasedComparator comparator) {
        for (int i = 0; i < length; ++i) {
            for (int j = i; j > 0 && comparator.compare(arr[j - 1], arr[j]) > 0; --j) {
                ArraysUtil.swap(arr, j, j - 1);
            }
        }
    }

    public static void sort(int[] arr, ScoreBasedComparator comparator) {
        ArraysUtil.sort(arr, arr.length, comparator);
    }

    public static void sort(int[] arr, int length, ScoreBasedComparator comparator) {
        int[] dest = new int[length];
        System.arraycopy(arr, 0, dest, 0, length);
        ArraysUtil.mergeSort(arr, dest, 0, length, 0, comparator);
        System.arraycopy(dest, 0, arr, 0, length);
    }

    public static int[] loadIntArrayFromLine(String line, int partsCount) throws Exception {
        String[] parts = line.split(" ");
        if (parts.length != partsCount) {
            throw new Exception("Invalid input.");
        }
        int[] result = new int[partsCount];
        for (int n = 0; n < partsCount; ++n) {
            result[n] = Integer.parseInt(parts[n]);
        }
        return result;
    }

    public static double[] loadDoubleArrayFromLine(String line, int partsCount) throws Exception {
        String[] parts = line.split(" ");
        if (parts.length != partsCount) {
            throw new Exception("Invalid input.");
        }
        double[] result = new double[partsCount];
        for (int n = 0; n < partsCount; ++n) {
            result[n] = Double.parseDouble(parts[n]);
        }
        return result;
    }

    public static double[][] loadDoubleMatrixFromLine(String line, int rows, int cols) throws Exception {
        String[] parts = line.split(" ");
        if (parts.length != rows * cols) {
            throw new Exception("Invalid input.");
        }
        double[][] result = new double[rows][cols];
        int idx = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                result[r][c] = Double.parseDouble(parts[idx]);
                ++idx;
            }
        }
        return result;
    }

    private static void mergeSort(int[] src, int[] dest, int low, int high, int off, ScoreBasedComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    ArraysUtil.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        ArraysUtil.mergeSort(dest, src, low, mid, -off, c);
        ArraysUtil.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    public static void swap(int[] arr, int a, int b) {
        int t = arr[a];
        arr[a] = arr[b];
        arr[b] = t;
    }

    public static void swap(double[] arr, int a, int b) {
        double t = arr[a];
        arr[a] = arr[b];
        arr[b] = t;
    }

    public static void shuffle(int[] list, Random rnd) {
        ArraysUtil.shuffle(list, list.length, rnd);
    }

    public static void shuffle(int[] list, int len, Random rnd) {
        for (int i = len; i > 1; --i) {
            ArraysUtil.swap(list, i - 1, rnd.nextInt(i));
        }
    }
}

