/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tools;

import edu.uci.jforests.input.FeatureValuePair;
import edu.uci.jforests.input.sparse.FeatureMetaData;
import edu.uci.jforests.input.sparse.MetaData;
import edu.uci.jforests.input.sparse.MetaLineParser;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.input.sparse.SparseTextFileReader;
import java.io.File;
import java.io.PrintStream;

public class Sparse2SvmConvertor {
    public static void convert(String inputFile, String outputFile) throws Exception {
        SparseTextFileReader reader = new SparseTextFileReader();
        reader.open(inputFile);
        SparseTextFileLine line = new SparseTextFileLine();
        int count = 0;
        PrintStream output = new PrintStream(new File(outputFile));
        StringBuilder sb = new StringBuilder();
        int featureCount = 0;
        while (reader.loadNextLine(line)) {
            if (line.meta) {
                MetaData metaData = MetaLineParser.parse(line.content);
                if (!(metaData instanceof FeatureMetaData)) continue;
                ++featureCount;
                continue;
            }
            sb.setLength(0);
            sb.append(line.target);
            for (int i = 0; i < line.numPairs; ++i) {
                FeatureValuePair pair = line.pairs[i];
                sb.append(" " + pair.featureIndex + ":" + pair.featureValue);
            }
            sb.append("\n");
            output.print(sb.toString());
            if (++count % 10000 != 0) continue;
            System.out.println("\t Processed: " + count);
        }
        output.close();
        reader.close();
    }
}

