/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tools;

import edu.uci.jforests.input.sparse.FeatureMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;

public class Csv2SparseConvertor {
    public static void convert(String inputFilename, String outputFilename, TargetPosition targetPosition, boolean hasHeader) {
        try {
            int fIdx;
            int targetColumn;
            int end;
            int start;
            int columnCount;
            File outputFile = new File(outputFilename);
            if (outputFile.exists()) {
                System.out.println("File: " + outputFilename + " already exists. Skipping it.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(new File(inputFilename)));
            String line = reader.readLine();
            String header = null;
            if (hasHeader) {
                header = line;
                line = reader.readLine();
                columnCount = header.split(",").length;
            } else {
                String firstLine = line;
                if (firstLine.indexOf(35) >= 0) {
                    firstLine = firstLine.substring(0, firstLine.indexOf(35));
                }
                columnCount = firstLine.split(",").length;
            }
            if (targetPosition == TargetPosition.FIRST) {
                start = 1;
                end = columnCount - 1;
                targetColumn = 0;
            } else if (targetPosition == TargetPosition.LAST) {
                start = 0;
                end = columnCount - 2;
                targetColumn = columnCount - 1;
            } else {
                start = 0;
                end = columnCount - 1;
                targetColumn = -1;
            }
            PrintStream output = new PrintStream(outputFile);
            if (hasHeader) {
                String[] colNames = header.split(",");
                HashMap<String, String> map = new HashMap<String, String>();
                for (int f = start; f <= end; ++f) {
                    fIdx = f - start + 1;
                    map.clear();
                    map.put("id", "" + fIdx);
                    map.put("name", colNames[f]);
                    output.println(new FeatureMetaData(map).toString());
                }
            }
            StringBuilder sb = new StringBuilder();
            int lineCount = 0;
            int curSize = 0;
            do {
                String comment;
                int commentStartIdx;
                if ((commentStartIdx = line.indexOf(35)) >= 0) {
                    comment = line.substring(commentStartIdx + 1).trim();
                    line = line.substring(0, commentStartIdx).trim();
                } else {
                    comment = null;
                }
                String[] parts = line.split(",");
                int target = 0;
                if (targetColumn >= 0) {
                    target = Integer.parseInt(parts[targetColumn]);
                }
                sb.append(target);
                for (int f = start; f <= end; ++f) {
                    fIdx = f - start + 1;
                    try {
                        double value = Double.parseDouble(parts[f]);
                        if (value == 0.0) continue;
                        String valueStr = "" + value;
                        if (valueStr.endsWith(".0")) {
                            valueStr = valueStr.substring(0, valueStr.length() - 2);
                        }
                        sb.append(" " + fIdx + ":" + valueStr);
                        continue;
                    }
                    catch (Exception e) {
                        sb.append(" " + fIdx + ":" + parts[f]);
                        System.out.println("Warning: feature: " + f + " had non-double value: " + parts[f]);
                    }
                }
                if (comment != null) {
                    sb.append(" # " + comment);
                }
                sb.append("\n");
                if (++curSize == 10000) {
                    output.print(sb.toString());
                    curSize = 0;
                    sb.setLength(0);
                }
                if (++lineCount % 10000 != 0) continue;
                System.out.print("\rProcessed lines: " + lineCount);
            } while ((line = reader.readLine()) != null);
            if (curSize > 0) {
                output.print(sb.toString());
            }
            System.out.println();
            reader.close();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetPosition {
        FIRST,
        LAST,
        NO_TARGET;

    }
}

