/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.regression;

import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.LeafInstances;
import edu.uci.jforests.learning.trees.TreeLeafInstances;
import edu.uci.jforests.learning.trees.regression.RegressionTreeSplit;
import edu.uci.jforests.sample.Sample;

public class RegressionCandidateSplitsForLeaf
extends CandidateSplitsForLeaf {
    protected double sumTargets;

    public RegressionCandidateSplitsForLeaf(int numFeatures, int numInstances) {
        super(numFeatures, numInstances);
        this.bestSplitPerFeature = new RegressionTreeSplit[numFeatures];
        for (int f = 0; f < numFeatures; ++f) {
            this.bestSplitPerFeature[f] = new RegressionTreeSplit();
        }
    }

    public double getSumTargets() {
        return this.sumTargets;
    }

    public void init(int curLeafIndex, TreeLeafInstances treeLeafInstances, Sample trainSet) {
        this.init(curLeafIndex);
        this.totalWeightedCount = 0.0;
        LeafInstances leafInstances = treeLeafInstances.getLeafInstances(curLeafIndex);
        this.numInstancesInLeaf = leafInstances.end - leafInstances.begin;
        this.sumTargets = 0.0;
        for (int i = 0; i < this.numInstancesInLeaf; ++i) {
            this.indices[i] = leafInstances.indices[leafInstances.begin + i];
            double target = trainSet.targets[this.indices[i]];
            double weight = trainSet.weights[this.indices[i]];
            this.targets[i] = target;
            this.weights[i] = weight;
            this.sumTargets += target * weight;
            this.totalWeightedCount += weight;
        }
    }
}

