/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees;

import edu.uci.jforests.config.ComponentConfig;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Map;

public class TreesConfig
extends ComponentConfig {
    public int numLeaves = 50;
    private static final String NUM_LEAVES = "trees.num-leaves";
    public double minInstancePercentagePerLeaf = 0.25;
    private static final String MIN_INSTANCE_PERCENTAGE_PER_LEAF = "trees.min-instance-percentage-per-leaf";
    public int minInstancePerLeaf = -1;
    private static final String MIN_INSTANCE_PER_LEAF = "trees.min-instance-per-leaf";
    public double featureSamplingPerSplit = 1.0;
    private static final String SPLIT_SAMPLING = "trees.feature-sampling";
    public boolean randomizedSplits = false;
    private static final String RANDOMIZED_SPLITS = "trees.randomized-splits";
    public String featuresToDiscard = null;
    private static final String FEATURES_TO_DISCARD = "trees.features-to-discard";
    public String featuresToInclude = null;
    private static final String FEATURES_TO_INCLUDE = "trees.features-to-include";

    public void init(ConfigHolder config) {
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            if (key.equals(SPLIT_SAMPLING)) {
                this.featureSamplingPerSplit = Double.parseDouble(value);
                continue;
            }
            if (key.equals(RANDOMIZED_SPLITS)) {
                this.randomizedSplits = value.equals("true");
                continue;
            }
            if (key.equals(NUM_LEAVES)) {
                this.numLeaves = Integer.parseInt(value);
                continue;
            }
            if (key.equals(MIN_INSTANCE_PERCENTAGE_PER_LEAF)) {
                this.minInstancePercentagePerLeaf = Double.parseDouble(value);
                continue;
            }
            if (key.equals(MIN_INSTANCE_PER_LEAF)) {
                this.minInstancePerLeaf = Integer.parseInt(value);
                continue;
            }
            if (key.equals(FEATURES_TO_DISCARD)) {
                this.featuresToDiscard = value;
                continue;
            }
            if (!key.equals(FEATURES_TO_INCLUDE)) continue;
            this.featuresToInclude = value;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("trees.num-leaves: " + this.numLeaves + "\n");
        sb.append("trees.min-instance-percentage-per-leaf: " + this.minInstancePercentagePerLeaf + "\n");
        sb.append("trees.min-instance-per-leaf: " + this.minInstancePerLeaf + "\n");
        sb.append("trees.feature-sampling: " + this.featureSamplingPerSplit + "\n");
        sb.append("trees.randomized-splits: " + this.randomizedSplits + "\n");
        sb.append("trees.features-to-discard: " + this.featuresToDiscard);
        return sb.toString();
    }
}

