/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input.sparse;

import edu.uci.jforests.input.FeatureValuePair;

public class SparseTextFileLine {
    private static final int DEFAULT_MAX_PAIRS = 1000;
    public int target;
    public String qid;
    public FeatureValuePair[] pairs = new FeatureValuePair[1000];
    public int numPairs;
    public boolean meta;
    public String content;

    public SparseTextFileLine() {
        for (int f = 0; f < 1000; ++f) {
            this.pairs[f] = new FeatureValuePair();
        }
        this.numPairs = 0;
    }

    public void ensureCapacity(int size) {
        if (this.pairs.length < size) {
            int f;
            int newSize = this.pairs.length * 2;
            if (size > newSize) {
                newSize = size;
            }
            FeatureValuePair[] newPairs = new FeatureValuePair[newSize];
            for (f = 0; f < this.pairs.length; ++f) {
                newPairs[f] = this.pairs[f];
            }
            for (f = this.pairs.length; f < newSize; ++f) {
                newPairs[f] = new FeatureValuePair();
            }
            this.pairs = newPairs;
        }
    }
}

