/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.BinaryFileReader;
import java.io.InputStream;

public class RankingBinFileReader
extends BinaryFileReader {
    private int[] queryBoundaries;
    private int numQueries;
    private int maxDocsPerQuery;

    public RankingBinFileReader(InputStream in) {
        super(in);
    }

    public int[] getQueryBoundaries() {
        return this.queryBoundaries;
    }

    public int getMaximumDocsPerQuery() {
        return this.maxDocsPerQuery;
    }

    protected void readHeader() throws Exception {
        super.readHeader();
        this.numQueries = this.readInt();
        this.queryBoundaries = new int[this.numQueries + 1];
    }

    public void read() throws Exception {
        int q;
        super.read();
        for (q = 0; q < this.numQueries + 1; ++q) {
            this.queryBoundaries[q] = this.readInt();
        }
        this.maxDocsPerQuery = 0;
        for (q = 0; q < this.numQueries; ++q) {
            int queryDocs = this.queryBoundaries[q + 1] - this.queryBoundaries[q];
            if (queryDocs <= this.maxDocsPerQuery) continue;
            this.maxDocsPerQuery = queryDocs;
        }
    }
}

