/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.util.Util;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class BinaryFileWriter {
    public static final int VERSION = 3;
    BufferedOutputStream output;
    private Feature[] features;
    private double[] targets;

    public BinaryFileWriter(String binFileName, Feature[] features, double[] targets) {
        try {
            File file = new File(binFileName);
            file.delete();
            this.output = new BufferedOutputStream(new FileOutputStream(file));
            this.features = features;
            this.targets = targets;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void write(byte[] arr) {
        try {
            this.output.write(arr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(byte b) {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeInt(int value) {
        this.write(Util.toByteArray(value));
    }

    private void write(double[] arr) {
        byte[] buf = new byte[8];
        for (int i = 0; i < arr.length; ++i) {
            Util.putDoubleInByteArray(arr[i], buf, 0);
            this.write(buf);
        }
    }

    private void writeFeature(Feature feature) {
        byte[] buf = new byte[feature.getSizeInBytes()];
        feature.toByteArray(buf, 0);
        this.write(buf);
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeHeader() {
        int f;
        this.writeInt(3);
        this.writeInt(this.features.length);
        this.writeInt(this.targets.length);
        for (f = 0; f < this.features.length; ++f) {
            this.writeInt(this.features[f].getSizeInBytes());
        }
        for (f = 0; f < this.features.length; ++f) {
            this.write((byte)this.features[f].getType().ordinal());
        }
    }

    public void write() {
        this.writeHeader();
        this.write(this.targets);
        for (int f = 0; f < this.features.length; ++f) {
            this.writeFeature(this.features[f]);
        }
    }
}

