/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval.ranking;

import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.eval.ranking.RankingEvaluationMetric;
import edu.uci.jforests.eval.ranking.TRiskAwareSAROEval;
import edu.uci.jforests.util.CDF_Normal;

public class TRiskAwareFAROEval
extends TRiskAwareSAROEval {
    public TRiskAwareFAROEval(EvaluationMetric _parent, double alpha) {
        super(_parent, alpha);
    }

    public RankingEvaluationMetric.SwapScorer getSwapScorer(double[] targets, int[] boundaries, int trunc, int[][] labelCounts) throws Exception {
        RankingEvaluationMetric.SwapScorer parentMeasure = ((RankingEvaluationMetric)this.parent).getSwapScorer(targets, boundaries, trunc, labelCounts);
        return new FAROSwapScorer(targets, boundaries, trunc, labelCounts, this.ALPHA, parentMeasure);
    }

    class FAROSwapScorer
    extends TRiskAwareSAROEval.SAROSwapScorer {
        public FAROSwapScorer(double[] targets, int[] boundaries, int trunc, int[][] labelCounts, double _alpha, RankingEvaluationMetric.SwapScorer _parent) {
            super(TRiskAwareFAROEval.this, targets, boundaries, trunc, labelCounts, _alpha, _parent);
        }

        public double getDelta(int queryIndex, int betterIdx, int rank_i, int worseIdx, int rank_j) {
            double delta_M = this.parentSwap.getDelta(queryIndex, betterIdx, rank_i, worseIdx, rank_j);
            double M_m = this.modelEval[queryIndex];
            double M_b = this.baselineEval[queryIndex];
            double d_i = M_m - M_b;
            double TRisk = d_i / this.currPairedSTD;
            double beta = (1.0 - CDF_Normal.normp(TRisk)) * this.alpha;
            double delta_T = (1.0 + beta) * delta_M;
            return delta_T;
        }
    }
}

