/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.util.Util;

public class ShortNumericArray
extends NumericArray {
    private short[] data;

    public ShortNumericArray(int length) {
        super(length);
        this.data = new short[length];
    }

    public int getSizeInBytes() {
        return 2 * this.length;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = (short)value;
    }

    public int getBitsPerItem() {
        return 16;
    }

    public int toByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            Util.putShortInByteArray(this.data[i], arr, offset);
            offset += 2;
        }
        return offset;
    }

    public int loadFromByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = Util.toShort(arr, offset);
            offset += 2;
        }
        return offset;
    }

    public NumericArrayFactory.NumericArrayType getType() {
        return NumericArrayFactory.NumericArrayType.SHORT;
    }

    public NumericArray getSubSampleNumericArray(int[] indices) {
        ShortNumericArray subsampleArray = new ShortNumericArray(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            subsampleArray.data[i] = this.data[indices[i]];
        }
        return subsampleArray;
    }
}

