/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.ByteSerializable;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.learning.trees.decision.DecisionHistogram;
import edu.uci.jforests.learning.trees.regression.RegressionHistogram;

public abstract class NumericArray
implements ByteSerializable {
    protected int length;

    public NumericArray(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public abstract NumericArrayFactory.NumericArrayType getType();

    public abstract int getBitsPerItem();

    public abstract int getSizeInBytes();

    public abstract int toByteArray(byte[] var1, int var2);

    public abstract int loadFromByteArray(byte[] var1, int var2);

    public abstract int get(int var1);

    public abstract void set(int var1, int var2);

    public void initHistogram(RegressionHistogram histogram, int numInstancesInLeaf, double[] targets, double[] weights, int[] indices, int[] instances) {
        for (int i = 0; i < numInstancesInLeaf; ++i) {
            int featureValue;
            int n = featureValue = this.get(instances[indices[i]]);
            histogram.perValueCount[n] = histogram.perValueCount[n] + 1;
            int n2 = featureValue;
            histogram.perValueWeightedCount[n2] = histogram.perValueWeightedCount[n2] + weights[i];
            int n3 = featureValue;
            histogram.perValueSumTargets[n3] = histogram.perValueSumTargets[n3] + targets[i] * weights[i];
        }
    }

    public void initHistogram(DecisionHistogram histogram, int numInstancesInLeaf, double[] targets, double[] weights, int[] indices, int[] instances) {
        for (int i = 0; i < numInstancesInLeaf; ++i) {
            int featureValue;
            int n = featureValue = this.get(instances[indices[i]]);
            histogram.perValueCount[n] = histogram.perValueCount[n] + 1;
            int n2 = featureValue;
            histogram.perValueWeightedCount[n2] = histogram.perValueWeightedCount[n2] + weights[i];
            double[] dArray = histogram.perValueTargetDist[featureValue];
            int n3 = (int)targets[i];
            dArray[n3] = dArray[n3] + weights[i];
        }
    }

    public abstract NumericArray getSubSampleNumericArray(int[] var1);
}

