/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.util.Util;

public class IntNumericArray
extends NumericArray {
    private int[] data;

    public IntNumericArray(int length) {
        super(length);
        this.data = new int[length];
    }

    public int getSizeInBytes() {
        return 2 * this.length;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public int getBitsPerItem() {
        return 32;
    }

    public int toByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            Util.putIntInByteArray(this.data[i], arr, offset);
            offset += 2;
        }
        return offset;
    }

    public int loadFromByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = Util.toInt(arr, offset);
            offset += 2;
        }
        return offset;
    }

    public NumericArrayFactory.NumericArrayType getType() {
        return NumericArrayFactory.NumericArrayType.INT;
    }

    public NumericArray getSubSampleNumericArray(int[] indices) {
        IntNumericArray subsampleArray = new IntNumericArray(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            subsampleArray.data[i] = this.data[indices[i]];
        }
        return subsampleArray;
    }
}

