/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.ByteSerializable;
import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.util.Util;

public class Feature
implements ByteSerializable {
    public final NumericArray bins;
    public int[] upperBounds;
    private String name;
    private double min;
    private double max;
    private double factor;
    private boolean onLogScale;

    public Feature(NumericArray _bins) {
        this.bins = _bins;
    }

    public NumericArrayFactory.NumericArrayType getType() {
        return this.bins.getType();
    }

    public int getNumberOfValues() {
        return this.upperBounds.length;
    }

    public double getOriginalValue(int scaledValue) {
        double value = (double)scaledValue / this.factor;
        if (this.onLogScale) {
            value = Math.exp(value);
            value = value + this.min - 1.0;
        } else {
            value += this.min;
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.length() > 127 ? name.substring(0, 127) : name;
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public boolean isOnLogScale() {
        return this.onLogScale;
    }

    public void setOnLogScale(boolean onLogScale) {
        this.onLogScale = onLogScale;
    }

    public Feature getSubSampleFeature(int[] indices) {
        Feature subSampleFeature = new Feature(this.bins.getSubSampleNumericArray(indices));
        subSampleFeature.upperBounds = this.upperBounds;
        subSampleFeature.name = this.name;
        subSampleFeature.min = this.min;
        subSampleFeature.max = this.max;
        subSampleFeature.factor = this.factor;
        subSampleFeature.onLogScale = this.onLogScale;
        return subSampleFeature;
    }

    public int getSizeInBytes() {
        int size = this.bins.getSizeInBytes();
        size += 4 + this.upperBounds.length * 4;
        size += 2 + (this.name != null ? this.name.length() : 0);
        return size += 25;
    }

    public int toByteArray(byte[] arr, int offset) {
        offset = this.bins.toByteArray(arr, offset);
        offset = Util.putIntArrayInByteArray(this.upperBounds, arr, offset);
        offset = Util.putStringInByteArray(this.name, arr, offset);
        offset = Util.putDoubleInByteArray(this.min, arr, offset);
        offset = Util.putDoubleInByteArray(this.max, arr, offset);
        offset = Util.putDoubleInByteArray(this.factor, arr, offset);
        offset = Util.putBooleanInByteArray(this.onLogScale, arr, offset);
        return offset;
    }

    public int loadFromByteArray(byte[] arr, int offset) {
        offset = this.bins.loadFromByteArray(arr, offset);
        this.upperBounds = Util.toIntArray(arr, offset);
        this.name = Util.toString(arr, offset += 4 + this.upperBounds.length * 4);
        this.min = Util.toDouble(arr, offset += 2 + this.name.length());
        this.max = Util.toDouble(arr, offset += 8);
        this.factor = Util.toDouble(arr, offset += 8);
        this.onLogScale = Util.toBoolean(arr, offset += 8);
        return ++offset;
    }
}

