/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.NumericArrayFactory;

public class ByteNumericArray
extends NumericArray {
    private byte[] data;

    public ByteNumericArray(int length) {
        super(length);
        this.data = new byte[length];
    }

    public int getSizeInBytes() {
        return this.data.length;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = (byte)value;
    }

    public int getBitsPerItem() {
        return 8;
    }

    public int toByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            arr[offset] = this.data[i];
            ++offset;
        }
        return offset;
    }

    public int loadFromByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = arr[offset];
            ++offset;
        }
        return offset;
    }

    public NumericArrayFactory.NumericArrayType getType() {
        return NumericArrayFactory.NumericArrayType.BYTE;
    }

    public NumericArray getSubSampleNumericArray(int[] indices) {
        ByteNumericArray subsampleArray = new ByteNumericArray(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            subsampleArray.data[i] = this.data[indices[i]];
        }
        return subsampleArray;
    }
}

