/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.learning.trees.decision.DecisionHistogram;
import edu.uci.jforests.learning.trees.regression.RegressionHistogram;

public class BitNumericArray
extends NumericArray {
    private byte[] data;

    public BitNumericArray(int length) {
        super(length);
        int arrLength = (int)Math.ceil((double)length / 8.0);
        this.data = new byte[arrLength];
    }

    public int getSizeInBytes() {
        return this.data.length;
    }

    public int get(int index) {
        return (this.data[index / 8] & 1 << index % 8) > 0 ? 1 : 0;
    }

    public void set(int index, int value) {
        int n = index / 8;
        this.data[n] = (byte)(this.data[n] | (byte)(value << index % 8));
    }

    public int getBitsPerItem() {
        return 1;
    }

    public int toByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.data.length; ++i) {
            arr[offset] = this.data[i];
            ++offset;
        }
        return offset;
    }

    public int loadFromByteArray(byte[] arr, int offset) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = arr[offset];
            ++offset;
        }
        return offset;
    }

    public NumericArrayFactory.NumericArrayType getType() {
        return NumericArrayFactory.NumericArrayType.BIT;
    }

    public void initHistogram(RegressionHistogram histogram, int numInstancesInLeaf, double[] targets, double[] weights, int[] indices, int[] instances) {
        double sumTargetsForOne = 0.0;
        double weightedCountForOne = 0.0;
        int countForOne = 0;
        for (int i = 0; i < numInstancesInLeaf; ++i) {
            int position = instances[indices[i]];
            int dataIndex = position / 8;
            int bitIndex = position % 8;
            byte v = this.data[dataIndex];
            if (((v = (byte)(v >> bitIndex)) & 1) <= 0) continue;
            double target = targets[i];
            double weight = weights[i];
            ++countForOne;
            weightedCountForOne += weight;
            sumTargetsForOne += target * weight;
        }
        histogram.perValueCount[0] = histogram.totalCount - countForOne;
        histogram.perValueCount[1] = countForOne;
        histogram.perValueWeightedCount[0] = histogram.totalWeightedCount - weightedCountForOne;
        histogram.perValueWeightedCount[1] = weightedCountForOne;
        histogram.perValueSumTargets[0] = histogram.sumTargets - sumTargetsForOne;
        histogram.perValueSumTargets[1] = sumTargetsForOne;
    }

    public void initHistogram(DecisionHistogram histogram, int numInstancesInLeaf, double[] targets, double[] weights, int[] indices, int[] instances) {
        double[] targetDistForOne = histogram.perValueTargetDist[1];
        double weightedCountForOne = 0.0;
        int countForOne = 0;
        for (int i = 0; i < numInstancesInLeaf; ++i) {
            int position = instances[indices[i]];
            int dataIndex = position / 8;
            int bitIndex = position % 8;
            byte v = this.data[dataIndex];
            if (((v = (byte)(v >> bitIndex)) & 1) <= 0) continue;
            double target = targets[i];
            double weight = weights[i];
            ++countForOne;
            weightedCountForOne += weight;
            int n = (int)target;
            targetDistForOne[n] = targetDistForOne[n] + weight;
        }
        histogram.perValueCount[0] = histogram.totalCount - countForOne;
        histogram.perValueCount[1] = countForOne;
        histogram.perValueWeightedCount[0] = histogram.totalWeightedCount - weightedCountForOne;
        histogram.perValueWeightedCount[1] = weightedCountForOne;
        int numClasses = histogram.targetDist.length;
        for (int c = 0; c < numClasses; ++c) {
            histogram.perValueTargetDist[0][c] = histogram.targetDist[c] - targetDistForOne[c];
        }
    }

    public NumericArray getSubSampleNumericArray(int[] indices) {
        BitNumericArray subsampleArray = new BitNumericArray(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            subsampleArray.set(i, this.get(indices[i]));
        }
        return subsampleArray;
    }
}

