/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.utils;

public strictfp final class NumbersUtils {
    private static final boolean ASSERTIONS = false;
    private static final int MIN_DOUBLE_EXPONENT = -1074;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final char[] CHAR_BY_DIGIT;
    private static final int[] DIV_SHIFT_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX;

    public static boolean equal(float a, float b) {
        return a == b ? true : a != a && b != b;
    }

    public static boolean equal(double a, double b) {
        return a == b ? true : a != a && b != b;
    }

    public static boolean isInRange(int min, int max, int a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(long min, long max, long a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(float min, float max, float a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(double min, double max, double a) {
        return min <= a && a <= max;
    }

    public static boolean checkIsInRange(int min, int max, int a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(a + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(long min, long max, long a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(a + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(float min, float max, float a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(a + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(double min, double max, double a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(a + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean isInRangeSigned(int a, int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.minSignedIntForBitSize_noCheck(bitSize) <= a && a <= NumbersUtils.maxSignedIntForBitSize_noCheck(bitSize);
    }

    public static boolean isInRangeSigned(long a, int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.minSignedLongForBitSize_noCheck(bitSize) <= a && a <= NumbersUtils.maxSignedLongForBitSize_noCheck(bitSize);
    }

    public static boolean isInRangeUnsigned(int a, int bitSize) {
        return NumbersUtils.isInRange(0, NumbersUtils.maxUnsignedIntForBitSize(bitSize), a);
    }

    public static boolean isInRangeUnsigned(long a, int bitSize) {
        return NumbersUtils.isInRange(0L, NumbersUtils.maxUnsignedLongForBitSize(bitSize), a);
    }

    public static boolean checkIsInRangeSigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(a + " does not fit as a signed value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeSigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(a + " does not fit as a signed value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(a + " does not fit as an unsigned value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(a + " does not fit as an unsigned value over " + bitSize + " bits");
        }
        return true;
    }

    public static int intMaskMSBits0(int bitSize) {
        NumbersUtils.checkIsInRange(0, 32, bitSize);
        int halfish = bitSize >> 1;
        return -1 >>> halfish >>> bitSize - halfish;
    }

    public static int intMaskMSBits1(int bitSize) {
        return ~NumbersUtils.intMaskMSBits0(bitSize);
    }

    public static int intMaskLSBits0(int bitSize) {
        return ~NumbersUtils.intMaskMSBits0(32 - bitSize);
    }

    public static int intMaskLSBits1(int bitSize) {
        return NumbersUtils.intMaskMSBits0(32 - bitSize);
    }

    public static long longMaskMSBits0(int bitSize) {
        NumbersUtils.checkIsInRange(0, 64, bitSize);
        int halfish = bitSize >> 1;
        return -1L >>> halfish >>> bitSize - halfish;
    }

    public static long longMaskMSBits1(int bitSize) {
        return NumbersUtils.longMaskMSBits0(bitSize) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long longMaskLSBits0(int bitSize) {
        return NumbersUtils.longMaskMSBits0(64 - bitSize) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long longMaskLSBits1(int bitSize) {
        return NumbersUtils.longMaskMSBits0(64 - bitSize);
    }

    public static short byteAsUnsigned(byte value) {
        return (short)((short)value & 0xFF);
    }

    public static int shortAsUnsigned(short value) {
        return value & 0xFFFF;
    }

    public static long intAsUnsigned(int value) {
        return (long)value & 0xFFFFFFFFFFFFFFFFL;
    }

    public static boolean isValidBitSizeForSignedInt(int bitSize) {
        return bitSize > 0 && bitSize <= 32;
    }

    public static boolean isValidBitSizeForSignedLong(int bitSize) {
        return bitSize > 0 && bitSize <= 64;
    }

    public static boolean isValidBitSizeForUnsignedInt(int bitSize) {
        return bitSize > 0 && bitSize < 32;
    }

    public static boolean isValidBitSizeForUnsignedLong(int bitSize) {
        return bitSize > 0 && bitSize < 64;
    }

    public static boolean checkBitSizeForSignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,32] for signed int values");
        }
        return true;
    }

    public static boolean checkBitSizeForSignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,64] for signed long values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,31] for unsigned int values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,63] for unsigned long values");
        }
        return true;
    }

    public static int minSignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.minSignedIntForBitSize_noCheck(bitSize);
    }

    public static long minSignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.minSignedLongForBitSize_noCheck(bitSize);
    }

    public static int maxSignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.maxSignedIntForBitSize_noCheck(bitSize);
    }

    public static long maxSignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.maxSignedLongForBitSize_noCheck(bitSize);
    }

    public static int maxUnsignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForUnsignedInt(bitSize);
        return Integer.MAX_VALUE >> 31 - bitSize;
    }

    public static long maxUnsignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForUnsignedLong(bitSize);
        return Long.MAX_VALUE >> 63 - bitSize;
    }

    public static int bitSizeForSignedValue(int value) {
        if (value > 0) {
            return 33 - Integer.numberOfLeadingZeros(value);
        }
        if (value == 0) {
            return 1;
        }
        return 33 - Integer.numberOfLeadingZeros(-value - 1);
    }

    public static int bitSizeForSignedValue(long value) {
        if (value > 0L) {
            return 65 - Long.numberOfLeadingZeros(value);
        }
        if (value == 0L) {
            return 1;
        }
        return 65 - Long.numberOfLeadingZeros(-value - 1L);
    }

    public static int bitSizeForUnsignedValue(int value) {
        if (value > 0) {
            return 32 - Integer.numberOfLeadingZeros(value);
        }
        if (value == 0) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value + "] must be >= 0");
    }

    public static int bitSizeForUnsignedValue(long value) {
        if (value > 0L) {
            return 64 - Long.numberOfLeadingZeros(value);
        }
        if (value == 0L) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value + "] must be >= 0");
    }

    public static int signum(int a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public static int signum(long a) {
        return a < 0L ? -1 : (a == 0L ? 0 : 1);
    }

    public static boolean isEven(int a) {
        return (a & 1) == 0;
    }

    public static boolean isEven(long a) {
        return NumbersUtils.isEven((int)a);
    }

    public static boolean isOdd(int a) {
        return (a & 1) != 0;
    }

    public static boolean isOdd(long a) {
        return NumbersUtils.isOdd((int)a);
    }

    public static boolean haveSameEvenness(int a, int b) {
        return ((a ^ b) & 1) == 0;
    }

    public static boolean haveSameEvenness(long a, long b) {
        return NumbersUtils.haveSameEvenness((int)a, (int)b);
    }

    public static boolean haveSameSign(int a, int b) {
        return (a ^ b) >= 0;
    }

    public static boolean haveSameSign(long a, long b) {
        return (a ^ b) >= 0L;
    }

    public static boolean isPowerOfTwo(int a) {
        if (a <= 0) {
            return false;
        }
        return (a & a - 1) == 0;
    }

    public static boolean isPowerOfTwo(long a) {
        if (a <= 0L) {
            return false;
        }
        return (a & a - 1L) == 0L;
    }

    public static boolean isSignedPowerOfTwo(int a) {
        if (a > 0) {
            return (a & a - 1) == 0;
        }
        if (a == -a) {
            return a != 0;
        }
        return (-a & -a - 1) == 0;
    }

    public static boolean isSignedPowerOfTwo(long a) {
        if (a > 0L) {
            return (a & a - 1L) == 0L;
        }
        if (a == -a) {
            return a != 0L;
        }
        return (-a & -a - 1L) == 0L;
    }

    public static int floorPowerOfTwo(int a) {
        if (a <= 0) {
            throw new IllegalArgumentException("a [" + a + "] must be > 0");
        }
        return 1 << 31 - Integer.numberOfLeadingZeros(a);
    }

    public static long floorPowerOfTwo(long a) {
        if (a <= 0L) {
            throw new IllegalArgumentException("a [" + a + "] must be > 0");
        }
        return 1L << 63 - Long.numberOfLeadingZeros(a);
    }

    public static int ceilingPowerOfTwo(int a) {
        NumbersUtils.checkIsInRange(0, 0x40000000, a);
        return 1 << 32 - Integer.numberOfLeadingZeros(a - 1);
    }

    public static long ceilingPowerOfTwo(long a) {
        NumbersUtils.checkIsInRange(0L, 0x4000000000000000L, a);
        return 1L << 64 - Long.numberOfLeadingZeros(a - 1L);
    }

    public static int meanLow(int a, int b) {
        return (a & b) + ((a ^ b) >> 1);
    }

    public static long meanLow(long a, long b) {
        return (a & b) + ((a ^ b) >> 1);
    }

    public static int meanSml(int a, int b) {
        int result = NumbersUtils.meanLow(a, b);
        if (!NumbersUtils.haveSameEvenness(a, b) && ((a & b) < 0 || (a | b) < 0 && a + b < 0)) {
            ++result;
        }
        return result;
    }

    public static long meanSml(long a, long b) {
        long result = NumbersUtils.meanLow(a, b);
        if (!NumbersUtils.haveSameEvenness(a, b) && ((a & b) < 0L || (a | b) < 0L && a + b < 0L)) {
            ++result;
        }
        return result;
    }

    public static int negHalfWidth(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min [" + min + "] must be <= max [" + max + "]");
        }
        int mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1);
    }

    public static long negHalfWidth(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min [" + min + "] must be <= max [" + max + "]");
        }
        long mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1L);
    }

    public static int moduloSignedPowerOfTwo(int value, int spot) {
        if (spot == Integer.MIN_VALUE) {
            return value != Integer.MIN_VALUE ? value : 0;
        }
        int s = value >> 31;
        return ((value + s ^ s) & NumbersUtils.abs(spot) - 1) + s ^ s;
    }

    public static long moduloSignedPowerOfTwo(long value, long spot) {
        if (spot == Long.MIN_VALUE) {
            return value != Long.MIN_VALUE ? value : 0L;
        }
        long s = value >> 63;
        return ((value + s ^ s) & NumbersUtils.abs(spot) - 1L) + s ^ s;
    }

    public static int log2(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("value [" + value + "] must be > 0");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int log2(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("value [" + value + "] must be > 0");
        }
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static int abs(int a) {
        return (a ^ a >> 31) - (a >> 31);
    }

    public static long abs(long a) {
        return (a ^ a >> 63) - (a >> 63);
    }

    public static double twoPow(int power) {
        if (power <= -1023) {
            if (power >= -1074) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return 0.0;
        }
        if (power > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    public static int intHash(long a) {
        int hash = (int)(a >> 32) + (int)a;
        if (a < 0L) {
            ++hash;
        }
        return hash;
    }

    public static byte asByte(int a) {
        if (a != (byte)a) {
            throw new ArithmeticException("overflow: " + a);
        }
        return (byte)a;
    }

    public static int asInt(long a) {
        if (a != (long)((int)a)) {
            throw new ArithmeticException("overflow: " + a);
        }
        return (int)a;
    }

    public static int toInt(long a) {
        if (a != (long)((int)a)) {
            return a < Integer.MIN_VALUE ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        return (int)a;
    }

    public static int plusExact(int a, int b) {
        if ((a ^ b) < 0) {
            return a + b;
        }
        int sum = a + b;
        if ((a ^ sum) < 0) {
            throw new ArithmeticException("overflow: " + a + "+" + b);
        }
        return sum;
    }

    public static long plusExact(long a, long b) {
        if ((a ^ b) < 0L) {
            return a + b;
        }
        long sum = a + b;
        if ((a ^ sum) < 0L) {
            throw new ArithmeticException("overflow: " + a + "+" + b);
        }
        return sum;
    }

    public static int plusBounded(int a, int b) {
        return NumbersUtils.toInt((long)a + (long)b);
    }

    public static long plusBounded(long a, long b) {
        if ((a ^ b) < 0L) {
            return a + b;
        }
        long sum = a + b;
        if ((a ^ sum) < 0L) {
            return sum >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return sum;
    }

    public static int minusExact(int a, int b) {
        if ((a ^ b) >= 0) {
            return a - b;
        }
        int diff = a - b;
        if ((a ^ diff) < 0) {
            throw new ArithmeticException("overflow: " + a + "-" + b);
        }
        return diff;
    }

    public static long minusExact(long a, long b) {
        if ((a ^ b) >= 0L) {
            return a - b;
        }
        long diff = a - b;
        if ((a ^ diff) < 0L) {
            throw new ArithmeticException("overflow: " + a + "-" + b);
        }
        return diff;
    }

    public static int minusBounded(int a, int b) {
        return NumbersUtils.toInt((long)a - (long)b);
    }

    public static long minusBounded(long a, long b) {
        if ((a ^ b) >= 0L) {
            return a - b;
        }
        long diff = a - b;
        if ((a ^ diff) < 0L) {
            return diff >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return diff;
    }

    public static int timesExact(int a, int b) {
        long product = (long)a * (long)b;
        if (product != (long)((int)product)) {
            throw new ArithmeticException("overflow: " + a + "*" + b);
        }
        return (int)product;
    }

    public static long timesExact(long a, long b) {
        long absB;
        long r = a * b;
        long absA = NumbersUtils.abs(a);
        if ((absA | (absB = NumbersUtils.abs(b))) >>> 31 != 0L && (b != 0L && r / b != a || a == Long.MIN_VALUE && b == -1L)) {
            throw new ArithmeticException("overflow: " + a + "*" + b);
        }
        return r;
    }

    public static int timesBounded(int a, int b) {
        return (int)((double)a * (double)b);
    }

    public static long timesBounded(long a, long b) {
        long absB;
        long r = a * b;
        long absA = NumbersUtils.abs(a);
        if ((absA | (absB = NumbersUtils.abs(b))) >>> 31 != 0L && (b != 0L && r / b != a || a == Long.MIN_VALUE && b == -1L)) {
            return (a ^ b) >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return r;
    }

    public static boolean isNaNOrInfinite(float a) {
        return a - a != 0.0f;
    }

    public static boolean isNaNOrInfinite(double a) {
        return a - a != 0.0;
    }

    public static int pow2(int a) {
        return a * a;
    }

    public static long pow2(long a) {
        return a * a;
    }

    public static float pow2(float a) {
        return a * a;
    }

    public static double pow2(double a) {
        return a * a;
    }

    public static int pow3(int a) {
        return a * a * a;
    }

    public static long pow3(long a) {
        return a * a * a;
    }

    public static float pow3(float a) {
        return a * a * a;
    }

    public static double pow3(double a) {
        return a * a * a;
    }

    public static int toRange(int min, int max, int a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static long toRange(long min, long max, long a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static float toRange(float min, float max, float a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static double toRange(double min, double max, double a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static boolean checkRadix(int radix) {
        if (!NumbersUtils.isInRange(2, 36, radix)) {
            throw new IllegalArgumentException("radix [" + radix + "] must be in [" + 2 + "," + 36 + "]");
        }
        return true;
    }

    public static int computeNbrOfChars(int value, int radix) {
        if (value < 0) {
            return 1 + NumbersUtils.computeNbrOfDigits_negValue(value, radix);
        }
        return NumbersUtils.computeNbrOfDigits_negValue(-value, radix);
    }

    public static int computeNbrOfChars(long value, int radix) {
        if (value < 0L) {
            return 1 + NumbersUtils.computeNbrOfDigits_negValue(value, radix);
        }
        return NumbersUtils.computeNbrOfDigits_negValue(-value, radix);
    }

    public static int computeNbrOfChars(int value, int radix, int paddingUpTo) {
        if (value < 0) {
            return 1 + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(value, radix));
        }
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(-value, radix));
    }

    public static int computeNbrOfChars(long value, int radix, int paddingUpTo) {
        if (value < 0L) {
            return 1 + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(value, radix));
        }
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(-value, radix));
    }

    public static int computeNbrOfDigits(int value, int radix) {
        return NumbersUtils.computeNbrOfDigits_negValue(-NumbersUtils.abs(value), radix);
    }

    public static int computeNbrOfDigits(long value, int radix) {
        return NumbersUtils.computeNbrOfDigits_negValue(-NumbersUtils.abs(value), radix);
    }

    public static int computeNbrOfDigits(int value, int radix, int paddingUpTo) {
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits(value, radix));
    }

    public static int computeNbrOfDigits(long value, int radix, int paddingUpTo) {
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits(value, radix));
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static String toString(int value, int radix) {
        return NumbersUtils.toString(value, radix, 0);
    }

    public static String toString(long value, int radix) {
        return NumbersUtils.toString(value, radix, 0);
    }

    public static String toString(int value, int radix, int paddingUpTo) {
        boolean radixIsPowerOfTwo;
        int signSize;
        int negValue;
        boolean negative;
        if (radix + paddingUpTo == 10 && paddingUpTo == 0) {
            return Integer.toString(value);
        }
        boolean bl = negative = value < 0;
        if (negative) {
            negValue = value;
            signSize = 1;
        } else {
            negValue = -value;
            signSize = 0;
        }
        int nbrOfChars = signSize + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(negValue, radix));
        char[] chars = new char[nbrOfChars];
        int charPos = nbrOfChars;
        boolean bl2 = radixIsPowerOfTwo = (radix & radix - 1) == 0;
        if (radixIsPowerOfTwo && negValue != Integer.MIN_VALUE) {
            int mask = radix - 1;
            int divShift = DIV_SHIFT_BY_RADIX[radix];
            while (negValue <= -radix) {
                chars[--charPos] = CHAR_BY_DIGIT[-negValue & mask];
                negValue = -(-negValue >> divShift);
            }
        } else {
            while (negValue <= -radix) {
                chars[--charPos] = CHAR_BY_DIGIT[-(negValue % radix)];
                negValue /= radix;
            }
        }
        chars[--charPos] = CHAR_BY_DIGIT[-negValue];
        while (charPos > signSize) {
            chars[--charPos] = 48;
        }
        if (negative) {
            chars[0] = 45;
        }
        return new String(chars);
    }

    public static String toString(long value, int radix, int paddingUpTo) {
        boolean radixIsPowerOfTwo;
        int signSize;
        long negValue;
        boolean negative;
        if (radix + paddingUpTo == 10 && paddingUpTo == 0) {
            return Long.toString(value);
        }
        boolean bl = negative = value < 0L;
        if (negative) {
            negValue = value;
            signSize = 1;
        } else {
            negValue = -value;
            signSize = 0;
        }
        int nbrOfChars = signSize + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(negValue, radix));
        char[] chars = new char[nbrOfChars];
        int charPos = nbrOfChars;
        boolean bl2 = radixIsPowerOfTwo = (radix & radix - 1) == 0;
        if (radixIsPowerOfTwo && negValue != Long.MIN_VALUE) {
            int mask = radix - 1;
            int divShift = DIV_SHIFT_BY_RADIX[radix];
            while (negValue <= (long)(-radix)) {
                chars[--charPos] = CHAR_BY_DIGIT[(int)(-negValue & (long)mask)];
                negValue = -(-negValue >> divShift);
            }
        } else {
            while (negValue <= (long)(-radix)) {
                chars[--charPos] = CHAR_BY_DIGIT[(int)(-(negValue % (long)radix))];
                negValue /= (long)radix;
            }
        }
        chars[--charPos] = CHAR_BY_DIGIT[(int)(-negValue)];
        while (charPos > signSize) {
            chars[--charPos] = 48;
        }
        if (negative) {
            chars[0] = 45;
        }
        return new String(chars);
    }

    public static boolean checkBitPositionsByte(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 8);
    }

    public static boolean checkBitPositionsShort(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 16);
    }

    public static boolean checkBitPositionsInt(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 32);
    }

    public static boolean checkBitPositionsLong(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 64);
    }

    public static String toStringBits(byte bits) {
        char[] chars = new char[8];
        int bitIndex = 8;
        while (--bitIndex >= 0) {
            chars[7 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(short bits) {
        char[] chars = new char[16];
        int bitIndex = 16;
        while (--bitIndex >= 0) {
            chars[15 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(int bits) {
        char[] chars = new char[32];
        int bitIndex = 32;
        while (--bitIndex >= 0) {
            chars[31 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(long bits) {
        char[] chars = new char[64];
        int bitIndex = 64;
        while (--bitIndex >= 0) {
            chars[63 - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
        }
        return new String(chars);
    }

    public static String toStringBits(byte bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsByte(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(8, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    public static String toStringBits(short bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsShort(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(16, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    public static String toStringBits(int bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsInt(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(32, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    public static String toStringBits(long bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsLong(firstBitPos, lastBitPosExcl);
        int bitSize = 64;
        int bitSizeM1 = 63;
        int lastBitPos = lastBitPosExcl - 1;
        if (padding) {
            int bitIndex;
            int nbrOfChars = 64;
            char[] chars = new char[64];
            if (bigEndian) {
                int firstBitIndex = 63 - lastBitPos;
                int lastBitIndex = 63 - firstBitPos;
                for (bitIndex = 63; bitIndex > lastBitIndex; --bitIndex) {
                    chars[63 - bitIndex] = 95;
                }
                while (bitIndex >= firstBitIndex) {
                    chars[63 - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[63 - bitIndex] = 95;
                    --bitIndex;
                }
            } else {
                while (bitIndex > lastBitPos) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
                while (bitIndex >= firstBitPos) {
                    chars[bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
            }
            return new String(chars);
        }
        int nbrOfChars = lastBitPosExcl - firstBitPos;
        char[] chars = new char[nbrOfChars];
        if (bigEndian) {
            int lastBitIndex;
            int firstBitIndex = 63 - lastBitPos;
            for (int bitIndex = lastBitIndex = 63 - firstBitPos; bitIndex >= firstBitIndex; --bitIndex) {
                chars[lastBitIndex - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
            }
        } else {
            for (int bitIndex = lastBitPos; bitIndex >= firstBitPos; --bitIndex) {
                chars[bitIndex - firstBitPos] = (char)(48L + (bits >> bitIndex & 1L));
            }
        }
        return new String(chars);
    }

    private static boolean dontUseMe_isInNonEmptyRange_(int min, int max, int a) {
        return Integer.MIN_VALUE + (a - min) <= Integer.MIN_VALUE + (max - min);
    }

    private static int minSignedIntForBitSize_noCheck(int bitSize) {
        return Integer.MIN_VALUE >> 32 - bitSize;
    }

    private static long minSignedLongForBitSize_noCheck(int bitSize) {
        return Long.MIN_VALUE >> 64 - bitSize;
    }

    private static int maxSignedIntForBitSize_noCheck(int bitSize) {
        return Integer.MAX_VALUE >> 32 - bitSize;
    }

    private static long maxSignedLongForBitSize_noCheck(int bitSize) {
        return Long.MAX_VALUE >> 64 - bitSize;
    }

    private static int computeNbrOfDigits_negValue(int negValue, int radix) {
        NumbersUtils.checkRadix(radix);
        int maxNbrOfDigits = MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX[radix];
        int p = radix;
        for (int i = 1; i < maxNbrOfDigits; ++i) {
            if (negValue > -p) {
                return i;
            }
            p *= radix;
        }
        return maxNbrOfDigits;
    }

    private static int computeNbrOfDigits_negValue(long negValue, int radix) {
        NumbersUtils.checkRadix(radix);
        int maxNbrOfDigits = MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX[radix];
        long p = radix;
        for (int i = 1; i < maxNbrOfDigits; ++i) {
            if (negValue > -p) {
                return i;
            }
            p *= (long)radix;
        }
        return maxNbrOfDigits;
    }

    private static boolean checkBitPositions(int firstBitPos, int lastBitPosExcl, int bitSize) {
        if (firstBitPos < 0 || firstBitPos > lastBitPosExcl || lastBitPosExcl > bitSize) {
            throw new IllegalArgumentException("bit positions (first=" + firstBitPos + ",lastExcl=" + lastBitPosExcl + ") must verify 0 <= first <= lastExcl <= " + bitSize);
        }
        return true;
    }

    private static String toStringBits_0_32_bitPosAlreadyChecked(int bitSize, int bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        int bitSizeM1 = bitSize - 1;
        int lastBitPos = lastBitPosExcl - 1;
        if (padding) {
            int bitIndex;
            int nbrOfChars = bitSize;
            char[] chars = new char[nbrOfChars];
            if (bigEndian) {
                int firstBitIndex = bitSizeM1 - lastBitPos;
                int lastBitIndex = bitSizeM1 - firstBitPos;
                for (bitIndex = bitSizeM1; bitIndex > lastBitIndex; --bitIndex) {
                    chars[bitSizeM1 - bitIndex] = 95;
                }
                while (bitIndex >= firstBitIndex) {
                    chars[bitSizeM1 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitSizeM1 - bitIndex] = 95;
                    --bitIndex;
                }
            } else {
                while (bitIndex > lastBitPos) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
                while (bitIndex >= firstBitPos) {
                    chars[bitIndex] = (char)(48 + (bits >> bitIndex & 1));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
            }
            return new String(chars);
        }
        int nbrOfChars = lastBitPosExcl - firstBitPos;
        char[] chars = new char[nbrOfChars];
        if (bigEndian) {
            int lastBitIndex;
            int firstBitIndex = bitSizeM1 - lastBitPos;
            for (int bitIndex = lastBitIndex = bitSizeM1 - firstBitPos; bitIndex >= firstBitIndex; --bitIndex) {
                chars[lastBitIndex - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
            }
        } else {
            for (int bitIndex = lastBitPos; bitIndex >= firstBitPos; --bitIndex) {
                chars[bitIndex - firstBitPos] = (char)(48 + (bits >> bitIndex & 1));
            }
        }
        return new String(chars);
    }

    static {
        int c;
        int minDecimal = 48;
        int maxDecimal = 57;
        int n1 = 10;
        int minLetter = 65;
        int maxLetter = 90;
        int n2 = 26;
        CHAR_BY_DIGIT = new char[36];
        int i = 0;
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            NumbersUtils.CHAR_BY_DIGIT[i++] = c;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            NumbersUtils.CHAR_BY_DIGIT[i++] = c;
        }
        DIV_SHIFT_BY_RADIX = new int[33];
        int shift = 1;
        for (int radix = 2; radix <= 32; radix *= 2) {
            NumbersUtils.DIV_SHIFT_BY_RADIX[radix] = shift++;
        }
        MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX = new int[37];
        MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX = new int[37];
        for (int radix = 2; radix <= 36; ++radix) {
            NumbersUtils.MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX[radix] = Integer.toString(Integer.MIN_VALUE, radix).length() - 1;
            NumbersUtils.MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX[radix] = Long.toString(Long.MIN_VALUE, radix).length() - 1;
        }
    }
}

