/*
 * Decompiled with CFR 0.152.
 */
package org.math.array;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import org.math.array.DoubleArray;

public class LinearAlgebra
extends DoubleArray {
    public static double[] minus(double[] v1, double[] v2) {
        LinearAlgebra.checkLength(v2, v1.length);
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] - v2[i];
        }
        return array;
    }

    public static double[] minus(double[] v1, double v) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] - v;
        }
        return array;
    }

    public static double[] minus(double v, double[] v1) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v - v1[i];
        }
        return array;
    }

    public static double[][] minus(double[][] v1, double[][] v2) {
        LinearAlgebra.checkRowDimension(v2, v1.length);
        LinearAlgebra.checkColumnDimension(v2, v1[0].length);
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                array[i][j] = v1[i][j] - v2[i][j];
            }
        }
        return array;
    }

    public static double[][] minus(double[][] v1, double v2) {
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                array[i][j] = v1[i][j] - v2;
            }
        }
        return array;
    }

    public static double[][] minus(double v2, double[][] v1) {
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                array[i][j] = v2 - v1[i][j];
            }
        }
        return array;
    }

    public static double[] plus(double[] ... v) {
        double[] array = new double[v[0].length];
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v[j].length; ++i) {
                int n = i;
                array[n] = array[n] + v[j][i];
            }
        }
        return array;
    }

    public static double[] plus(double[] v1, double v) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] + v;
        }
        return array;
    }

    public static double[][] plus(double[][] v1, double[][] v2) {
        LinearAlgebra.checkRowDimension(v2, v1.length);
        LinearAlgebra.checkColumnDimension(v2, v1[0].length);
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                array[i][j] = v1[i][j] + v2[i][j];
            }
        }
        return array;
    }

    public static double[][] plus(double[][] v1, double v2) {
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                array[i][j] = v1[i][j] + v2;
            }
        }
        return array;
    }

    public static double[] times(double[] ... v) {
        double[] array = LinearAlgebra.fill(v[0].length, 1.0);
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v[j].length; ++i) {
                int n = i;
                array[n] = array[n] * v[j][i];
            }
        }
        return array;
    }

    public static double[] divide(double[] v1, double[] v2) {
        LinearAlgebra.checkLength(v1, v2.length);
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] / v2[i];
        }
        return array;
    }

    public static double[] times(double[] v1, double v) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] * v;
        }
        return array;
    }

    public static double[][] times(double[][] v1, double v) {
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[i].length; ++j) {
                array[i][j] = v1[i][j] * v;
            }
        }
        return array;
    }

    public static double[] divide(double[] v1, double v) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = v1[i] / v;
        }
        return array;
    }

    public static double[][] divide(double[][] v1, double v) {
        double[][] array = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[i].length; ++j) {
                array[i][j] = v1[i][j] / v;
            }
        }
        return array;
    }

    public static double[] raise(double[] v1, double n) {
        double[] array = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            array[i] = Math.pow(v1[i], n);
        }
        return array;
    }

    public static double[][] raise(double[][] v, double n) {
        double[][] array = new double[v.length][v[0].length];
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                array[i][j] = Math.pow(v[i][j], n);
            }
        }
        return array;
    }

    public static double[][] times(double[][] v1, double[][] v2) {
        LinearAlgebra.checkRowDimension(v2, v1[0].length);
        double[][] array = new double[v1.length][v2[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                double tmp = 0.0;
                for (int k = 0; k < v1[0].length; ++k) {
                    tmp += v1[i][k] * v2[k][j];
                }
                array[i][j] = tmp;
            }
        }
        return array;
    }

    public static double[] times(double[][] v1, double[] v2) {
        LinearAlgebra.checkLength(v2, v1[0].length);
        return LinearAlgebra.getColumnCopy(LinearAlgebra.times(v1, LinearAlgebra.columnVector(v2)), 0);
    }

    public static double[][] divideLU(double[][] v1, double[] ... v2) {
        return LinearAlgebra.LU(v2).solve(Matrix.constructWithCopy((double[][])v1)).getArray();
    }

    public static double[][] divideQR(double[][] v1, double[] ... v2) {
        return LinearAlgebra.QR(v2).solve(Matrix.constructWithCopy((double[][])v1)).getArray();
    }

    public static double[][] divide(double[][] v1, double[] ... v2) {
        return LinearAlgebra.divideQR(v1, v2);
    }

    public static double[][] inverseLU(double[][] v1) {
        LinearAlgebra.checkColumnDimension(v1, v1.length);
        return LinearAlgebra.LU(v1).solve(Matrix.identity((int)v1.length, (int)v1.length)).getArray();
    }

    public static double[][] inverseQR(double[][] v1) {
        LinearAlgebra.checkColumnDimension(v1, v1.length);
        return LinearAlgebra.QR(v1).solve(Matrix.identity((int)v1.length, (int)v1.length)).getArray();
    }

    public static double[][] inverse(double[][] v1) {
        return new Matrix(v1).inverse().getArray();
    }

    public static double[][] solve(double[][] A, double[][] B) {
        return new Matrix(A).solve(new Matrix(B)).getArray();
    }

    public static double[][] solveTranspose(double[][] A, double[][] B) {
        return new Matrix(A).solveTranspose(new Matrix(B)).getArray();
    }

    public static EigenvalueDecomposition eigen(double[][] v) {
        return new EigenvalueDecomposition(new Matrix(v));
    }

    public static QRDecomposition QR(double[][] v) {
        return new QRDecomposition(Matrix.constructWithCopy((double[][])v));
    }

    public static LUDecomposition LU(double[][] v) {
        return new LUDecomposition(Matrix.constructWithCopy((double[][])v));
    }

    public static CholeskyDecomposition cholesky(double[][] v) {
        return new CholeskyDecomposition(new Matrix(v));
    }

    public static SingularValueDecomposition singular(double[][] v) {
        return new SingularValueDecomposition(new Matrix(v));
    }

    public static double cond(double[][] v) {
        return new Matrix(v).cond();
    }

    public static double det(double[][] v) {
        return new Matrix(v).det();
    }

    public static int rank(double[][] v) {
        return new Matrix(v).rank();
    }

    public static double trace(double[][] v) {
        return new Matrix(v).trace();
    }

    public static double norm1(double[][] v) {
        return new Matrix(v).norm1();
    }

    public static double norm2(double[][] v) {
        return new Matrix(v).norm2();
    }

    public static double normF(double[][] v) {
        return new Matrix(v).normF();
    }

    public static double normInf(double[][] v) {
        return new Matrix(v).normInf();
    }
}

