/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger;

import com.github.yangkangli.logger.core.BaseLogStrategy;
import com.github.yangkangli.logger.core.ILogAdapter;
import com.github.yangkangli.logger.core.LoggerCore;

public class ALogger {
    private LoggerCore loggerCore = new LoggerCore();

    private static ALogger getInstance() {
        return Holder.INSTANCE;
    }

    private ALogger() {
    }

    public static void setLogStrategy(BaseLogStrategy strategy) {
        ALogger.getInstance().loggerCore.setStrategy(strategy);
    }

    public static void addLogAdapter(ILogAdapter ... logAdapters) {
        if (logAdapters != null && logAdapters.length > 0) {
            for (ILogAdapter adapter : logAdapters) {
                ALogger.getInstance().loggerCore.addAdapter(adapter);
            }
        }
    }

    public static void v(Object message) {
        ALogger.getInstance().loggerCore.v(null, message, null);
    }

    public static void v(String subTag, Object message) {
        ALogger.getInstance().loggerCore.v(subTag, message, null);
    }

    public static void v(Throwable throwable) {
        ALogger.getInstance().loggerCore.v(null, null, throwable);
    }

    public static void v(String subTag, Throwable throwable) {
        ALogger.getInstance().loggerCore.v(subTag, null, throwable);
    }

    public static void v(String subTag, Object message, Throwable throwable) {
        ALogger.getInstance().loggerCore.v(subTag, message, throwable);
    }

    public static void d(Object message) {
        ALogger.getInstance().loggerCore.d(null, message, null);
    }

    public static void d(String subTag, Object message) {
        ALogger.getInstance().loggerCore.d(subTag, message, null);
    }

    public static void d(Throwable throwable) {
        ALogger.getInstance().loggerCore.d(null, null, throwable);
    }

    public static void d(String subTag, Throwable throwable) {
        ALogger.getInstance().loggerCore.d(subTag, null, throwable);
    }

    public static void d(String subTag, Object message, Throwable throwable) {
        ALogger.getInstance().loggerCore.d(subTag, message, throwable);
    }

    public static void i(Object message) {
        ALogger.getInstance().loggerCore.i(null, message, null);
    }

    public static void i(String subTag, Object message) {
        ALogger.getInstance().loggerCore.i(subTag, message, null);
    }

    public static void i(Throwable throwable) {
        ALogger.getInstance().loggerCore.i(null, null, throwable);
    }

    public static void i(String subTag, Throwable throwable) {
        ALogger.getInstance().loggerCore.i(subTag, null, throwable);
    }

    public static void i(String subTag, Object message, Throwable throwable) {
        ALogger.getInstance().loggerCore.i(subTag, message, throwable);
    }

    public static void w(Object message) {
        ALogger.getInstance().loggerCore.w(null, message, null);
    }

    public static void w(String subTag, Object message) {
        ALogger.getInstance().loggerCore.w(subTag, message, null);
    }

    public static void w(Throwable throwable) {
        ALogger.getInstance().loggerCore.w(null, null, throwable);
    }

    public static void w(String subTag, Throwable throwable) {
        ALogger.getInstance().loggerCore.w(subTag, null, throwable);
    }

    public static void w(String subTag, Object message, Throwable throwable) {
        ALogger.getInstance().loggerCore.w(subTag, message, throwable);
    }

    public static void e(Object message) {
        ALogger.getInstance().loggerCore.e(null, message, null);
    }

    public static void e(String subTag, Object message) {
        ALogger.getInstance().loggerCore.e(subTag, message, null);
    }

    public static void e(Throwable throwable) {
        ALogger.getInstance().loggerCore.e(null, null, throwable);
    }

    public static void e(String subTag, Throwable throwable) {
        ALogger.getInstance().loggerCore.e(subTag, null, throwable);
    }

    public static void e(String subTag, Object message, Throwable throwable) {
        ALogger.getInstance().loggerCore.e(subTag, message, throwable);
    }

    public static void json(String json) {
        ALogger.getInstance().loggerCore.json(null, null, json);
    }

    public static void json(String subTag, String json) {
        ALogger.getInstance().loggerCore.json(subTag, null, json);
    }

    public static void jsonWithTitle(String title, String json) {
        ALogger.getInstance().loggerCore.json(null, title, json);
    }

    public static void jsonWithTitle(String subTag, String title, String json) {
        ALogger.getInstance().loggerCore.json(subTag, title, json);
    }

    public static void xml(String xml) {
        ALogger.getInstance().loggerCore.xml(null, null, xml);
    }

    public static void xml(String subTag, String xml) {
        ALogger.getInstance().loggerCore.xml(subTag, null, xml);
    }

    public static void xmlWithTitle(String title, String xml) {
        ALogger.getInstance().loggerCore.xml(null, title, xml);
    }

    public static void xmlWithTitle(String subTag, String title, String xml) {
        ALogger.getInstance().loggerCore.xml(subTag, title, xml);
    }

    private static class Holder {
        private static final ALogger INSTANCE = new ALogger();

        private Holder() {
        }
    }
}

