/*
 * Decompiled with CFR 0.152.
 */
package com.yangfan.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ModifyTabLayout
extends HorizontalScrollView {
    private OnTabLayoutItemSelectListener onTabLayoutItemSelectListener;
    private List<TextView> mViewsList;
    private int mTextColorUnSelect;
    private int mTextColorSelect;
    private int mTextBgUnSelectResId;
    private int mTextBgSelectResId;
    private List<CharSequence> mTabList;
    private LinearLayout layContent;
    private View bottomLine;
    private int bottomLineHeight;
    private int bottomLineWidth;
    private int bottomLineHeightBgResId;
    private int mScrollViewWidth = 0;
    private int mScrollViewMiddle = 0;
    private int selectedTabPosition = -1;
    private int tabCount;
    private Handler mHandler = null;
    private int viewHeight = ModifyTabLayout.dip2px(this.getContext(), 40.0f);
    private int innerLeftMargin = ModifyTabLayout.dip2px(this.getContext(), 15.0f);
    private int innerRightMargin = ModifyTabLayout.dip2px(this.getContext(), 15.0f);
    private int itemInnerPaddingLeft;
    private int itemInnerPaddingRight;
    private float textSize = 14.0f;
    private ViewPager mViewPager;
    private TabLayoutOnPageChangeListener mPageChangeListener;
    private boolean needEqual;
    private int mWidth;

    public ModifyTabLayout(Context context) {
        this(context, null);
    }

    public ModifyTabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mHandler = new StaticHandler(context, this);
        this.mViewsList = new ArrayList<TextView>();
        this.mTextColorUnSelect = -16777216;
        this.mTextColorSelect = -65536;
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalFadingEdgeEnabled(false);
        FrameLayout layParent = new FrameLayout(context);
        this.addView((View)layParent);
        this.layContent = new LinearLayout(context);
        layParent.addView((View)this.layContent);
        this.bottomLine = new View(context);
        layParent.addView(this.bottomLine);
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setInnerLeftMargin(int innerLeftMargin) {
        this.innerLeftMargin = innerLeftMargin;
    }

    public void setInnerRightMargin(int innerRightMargin) {
        this.innerRightMargin = innerRightMargin;
    }

    public void setmTextBgUnSelectResId(int mTextBgUnSelectResId) {
        this.mTextBgUnSelectResId = mTextBgUnSelectResId;
    }

    public void setmTextBgSelectResId(int mTextBgSelectResId) {
        this.mTextBgSelectResId = mTextBgSelectResId;
    }

    public void setmTextColorSelect(int mTextColorSelect) {
        this.mTextColorSelect = mTextColorSelect;
    }

    public void setmTextColorSelectId(int colorId) {
        this.mTextColorSelect = this.getResources().getColor(colorId);
    }

    public void setmTextColorUnSelect(int mTextColorUnSelect) {
        this.mTextColorUnSelect = mTextColorUnSelect;
    }

    public void setmTextColorUnSelectId(int colorId) {
        this.mTextColorUnSelect = this.getResources().getColor(colorId);
    }

    public void setViewHeight(int viewHeightPx) {
        this.viewHeight = viewHeightPx;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setNeedEqual(boolean needEqual, int mWidth) {
        this.needEqual = needEqual;
        this.mWidth = mWidth;
    }

    public void setItemInnerPaddingLeft(int itemInnerPaddingLeft) {
        this.itemInnerPaddingLeft = itemInnerPaddingLeft;
    }

    public void setItemInnerPaddingRight(int itemInnerPaddingRight) {
        this.itemInnerPaddingRight = itemInnerPaddingRight;
    }

    public void setBottomLineHeight(int bottomLineHeight) {
        this.bottomLineHeight = bottomLineHeight;
    }

    public void setBottomLineWidth(int bottomLineWidth) {
        this.bottomLineWidth = bottomLineWidth;
    }

    public void setBottomLineHeightBgResId(int bottomLineHeightBgResId) {
        this.bottomLineHeightBgResId = bottomLineHeightBgResId;
    }

    public View getBottomLine() {
        return this.bottomLine;
    }

    private void setData(List<CharSequence> mTabList) {
        if (mTabList == null || mTabList.size() == 0) {
            return;
        }
        this.mTabList = mTabList;
        this.initView();
    }

    public void setTabData(List<CharSequence> mTabList, int defaultPos) {
        if (mTabList == null || mTabList.size() == 0) {
            return;
        }
        this.mTabList = mTabList;
        this.selectedTabPosition = defaultPos >= 0 && defaultPos < mTabList.size() ? defaultPos : 0;
        this.initView();
        this.clickTabWithItem(this.selectedTabPosition);
    }

    private void initView() {
        if (this.mTabList == null || this.mTabList.size() == 0) {
            return;
        }
        this.mViewsList = new ArrayList<TextView>();
        this.layContent.removeAllViews();
        for (int i = 0; i < this.mTabList.size(); ++i) {
            TextView textView = new TextView(this.getContext());
            if (this.needEqual) {
                LinearLayout linearLayout = new LinearLayout(this.getContext());
                linearLayout.setGravity(17);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                if (this.mWidth > 0) {
                    layoutParams.width = this.mWidth / this.mTabList.size();
                }
                linearLayout.addView((View)textView);
                this.layContent.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.layContent.addView((View)textView);
            }
            textView.setTextSize(this.textSize);
            textView.setGravity(16);
            if (i == this.selectedTabPosition) {
                textView.setBackgroundResource(this.mTextBgSelectResId);
                textView.setTextColor(this.mTextColorSelect);
            } else {
                textView.setBackgroundResource(this.mTextBgUnSelectResId);
                textView.setTextColor(this.mTextColorUnSelect);
            }
            textView.setTag((Object)i);
            textView.setText(this.mTabList.get(i));
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int position = Integer.parseInt(view.getTag().toString());
                    if (ModifyTabLayout.this.mViewPager != null) {
                        ModifyTabLayout.this.mViewPager.setCurrentItem(position);
                    } else {
                        ModifyTabLayout.this.clickTabWithItem(position);
                    }
                }
            });
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            if (!this.needEqual) {
                layoutParams.rightMargin = this.innerRightMargin;
                layoutParams.leftMargin = this.innerLeftMargin;
            }
            layoutParams.height = this.viewHeight;
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setPadding(this.itemInnerPaddingLeft, 0, this.itemInnerPaddingRight, 0);
            this.mViewsList.add(textView);
        }
        this.initBottomLine();
        this.mHandler.sendEmptyMessageDelayed(0, 200L);
    }

    private void initBottomLine() {
        this.bottomLine.setBackgroundResource(this.bottomLineHeightBgResId);
        FrameLayout.LayoutParams fl = (FrameLayout.LayoutParams)this.bottomLine.getLayoutParams();
        fl.width = this.bottomLineWidth;
        fl.height = this.bottomLineHeight;
        fl.gravity = 80;
        this.bottomLine.setLayoutParams((ViewGroup.LayoutParams)fl);
    }

    private void clickTabWithItem(int position) {
        if (this.mViewsList == null) {
            return;
        }
        this.selectedTabPosition = position;
        if (null != this.onTabLayoutItemSelectListener) {
            this.onTabLayoutItemSelectListener.onTabLayoutItemSelect(position);
        }
        for (int i = 0; i < this.mViewsList.size(); ++i) {
            TextView textView = this.mViewsList.get(i);
            if (Integer.parseInt(this.mViewsList.get(i).getTag().toString()) == position) {
                this.changeTextLocation(i);
                textView.setBackgroundResource(this.mTextBgSelectResId);
                textView.setTextColor(this.mTextColorSelect);
            } else {
                this.mViewsList.get(i).setBackgroundResource(this.mTextBgUnSelectResId);
                this.mViewsList.get(i).setTextColor(this.mTextColorUnSelect);
            }
            textView.setPadding(this.itemInnerPaddingLeft, 0, this.itemInnerPaddingRight, 0);
        }
    }

    public void setCurrentItem(int position) {
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(position);
        } else {
            this.clickTabWithItem(position);
        }
    }

    public TextView getTextView(int position) {
        if (this.mViewsList == null || position >= this.mViewsList.size()) {
            throw new RuntimeException("mViewsList == null || position >= mViewsList.size()");
        }
        return this.mViewsList.get(position);
    }

    public LinearLayout getLayContent() {
        return this.layContent;
    }

    private void changeTextLocation(int clickPosition) {
        if (clickPosition >= 0 && clickPosition < this.mViewsList.size()) {
            this.changebottomLineLocation();
            int x = this.mViewsList.get(clickPosition).getLeft() - this.getScrollViewMiddle() + this.getViewheight((View)this.mViewsList.get(clickPosition)) / 2;
            this.smoothScrollTo(x, 0);
        }
    }

    private void changebottomLineLocation() {
        if (this.selectedTabPosition >= 0 && this.selectedTabPosition < this.mViewsList.size()) {
            int x;
            TextView textView = this.getTextView(this.selectedTabPosition);
            if (this.needEqual) {
                int[] position = new int[2];
                textView.getLocationOnScreen(position);
                int l1 = position[0];
                if (l1 == 0) {
                    int sWidth = this.mWidth / this.mViewsList.size();
                    int bWidth = sWidth / 2;
                    textView.measure(0, 0);
                    l1 = sWidth * this.selectedTabPosition + bWidth - textView.getMeasuredWidth() / 2;
                }
                x = l1 + (textView.getRight() - textView.getLeft() - this.bottomLineWidth) / 2;
            } else {
                x = textView.getLeft() + (textView.getRight() - textView.getLeft() - this.bottomLineWidth) / 2;
            }
            FrameLayout.LayoutParams fl = (FrameLayout.LayoutParams)this.bottomLine.getLayoutParams();
            fl.leftMargin = x;
            this.bottomLine.setLayoutParams((ViewGroup.LayoutParams)fl);
        }
    }

    private int getScrollViewMiddle() {
        if (this.mScrollViewMiddle == 0) {
            this.mScrollViewMiddle = this.getScrollViewWidth() / 2;
        }
        return this.mScrollViewMiddle;
    }

    private int getScrollViewWidth() {
        if (this.mScrollViewWidth == 0) {
            this.mScrollViewWidth = this.getRight() - this.getLeft();
        }
        return this.mScrollViewWidth;
    }

    private int getViewheight(View view) {
        return view.getBottom() - view.getTop();
    }

    private static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mPageChangeListener == null) {
                this.mPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            this.mPageChangeListener.reset();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
            this.selectedTabPosition = viewPager.getCurrentItem();
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.tabCount = adapter.getCount();
                ArrayList<CharSequence> tabList = new ArrayList<CharSequence>();
                for (int i = 0; i < this.tabCount; ++i) {
                    tabList.add(adapter.getPageTitle(i));
                }
                this.setData(tabList);
            } else {
                this.tabCount = 0;
            }
        }
    }

    public int getSelectedTabPosition() {
        return this.selectedTabPosition;
    }

    public int getTabCount() {
        return this.tabCount;
    }

    public void setOnTabLayoutItemSelectListener(OnTabLayoutItemSelectListener listener) {
        this.onTabLayoutItemSelectListener = listener;
    }

    public static interface OnTabLayoutItemSelectListener {
        public void onTabLayoutItemSelect(int var1);
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<ModifyTabLayout> mTabLayoutRef;
        private int mPreviousScrollState;
        private int mScrollState;

        public TabLayoutOnPageChangeListener(ModifyTabLayout tabLayout) {
            this.mTabLayoutRef = new WeakReference<ModifyTabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            ModifyTabLayout tabLayout = (ModifyTabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position && position < tabLayout.getTabCount()) {
                tabLayout.clickTabWithItem(position);
            }
        }

        void reset() {
            this.mScrollState = 0;
            this.mPreviousScrollState = 0;
        }
    }

    private static class StaticHandler
    extends Handler {
        private final WeakReference<Context> mWeakContext;
        private final WeakReference<ModifyTabLayout> mParent;

        public StaticHandler(Context context, ModifyTabLayout view) {
            this.mWeakContext = new WeakReference<Context>(context);
            this.mParent = new WeakReference<ModifyTabLayout>(view);
        }

        public void handleMessage(Message msg) {
            Context context = (Context)this.mWeakContext.get();
            ModifyTabLayout parent = (ModifyTabLayout)((Object)this.mParent.get());
            if (null != context && null != parent) {
                switch (msg.what) {
                    case 0: {
                        parent.changeTextLocation(parent.selectedTabPosition);
                        break;
                    }
                }
                super.handleMessage(msg);
            }
        }
    }
}

