/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization;

import com.ironz.binaryprefs.exception.SerializationException;
import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteArraySerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.PersistableSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSetSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.PersistableRegistry;
import java.util.HashSet;
import java.util.Set;

public final class SerializerFactory {
    private static final String ZERO_BYTES_MESSAGE = "%s key's value is zero bytes for deserialize";
    private final BooleanSerializer booleanSerializer = new BooleanSerializer();
    private final ByteSerializer byteSerializer = new ByteSerializer();
    private final ByteArraySerializer byteArraySerializer;
    private final CharSerializer charSerializer = new CharSerializer();
    private final DoubleSerializer doubleSerializer = new DoubleSerializer();
    private final FloatSerializer floatSerializer = new FloatSerializer();
    private final IntegerSerializer integerSerializer = new IntegerSerializer();
    private final LongSerializer longSerializer = new LongSerializer();
    private final ShortSerializer shortSerializer = new ShortSerializer();
    private final StringSerializer stringSerializer = new StringSerializer();
    private final StringSetSerializer stringSetSerializer = new StringSetSerializer();
    private final PersistableSerializer persistableSerializer;

    public SerializerFactory(PersistableRegistry persistableRegistry) {
        this.byteArraySerializer = new ByteArraySerializer();
        this.persistableSerializer = new PersistableSerializer(this.booleanSerializer, this.byteSerializer, this.byteArraySerializer, this.charSerializer, this.doubleSerializer, this.floatSerializer, this.integerSerializer, this.longSerializer, this.shortSerializer, this.stringSerializer, persistableRegistry);
    }

    public Object deserialize(String key, byte[] bytes) {
        if (bytes.length == 0) {
            throw new SerializationException(String.format(ZERO_BYTES_MESSAGE, key));
        }
        byte flag = bytes[0];
        if (this.booleanSerializer.isMatches(flag)) {
            return this.booleanSerializer.deserialize(bytes);
        }
        if (this.integerSerializer.isMatches(flag)) {
            return this.integerSerializer.deserialize(bytes);
        }
        if (this.longSerializer.isMatches(flag)) {
            return this.longSerializer.deserialize(bytes);
        }
        if (this.doubleSerializer.isMatches(flag)) {
            return this.doubleSerializer.deserialize(bytes);
        }
        if (this.floatSerializer.isMatches(flag)) {
            return Float.valueOf(this.floatSerializer.deserialize(bytes));
        }
        if (this.stringSerializer.isMatches(flag)) {
            return this.stringSerializer.deserialize(bytes);
        }
        if (this.stringSetSerializer.isMatches(flag)) {
            return this.stringSetSerializer.deserialize(bytes);
        }
        if (this.persistableSerializer.isMatches(flag)) {
            return this.persistableSerializer.deserialize(key, bytes);
        }
        if (this.shortSerializer.isMatches(flag)) {
            return this.shortSerializer.deserialize(bytes);
        }
        if (this.byteSerializer.isMatches(flag)) {
            return this.byteSerializer.deserialize(bytes);
        }
        if (this.byteArraySerializer.isMatches(flag)) {
            return this.byteArraySerializer.deserialize(bytes);
        }
        if (this.charSerializer.isMatches(flag)) {
            return Character.valueOf(this.charSerializer.deserialize(bytes));
        }
        throw new UnsupportedClassVersionError(String.format("Flag verification failed. Incorrect flag '%s'", flag));
    }

    public Object redefineMutable(Object o) {
        if (o instanceof Persistable) {
            return ((Persistable)o).deepClone();
        }
        if (o instanceof Set) {
            Set strings = (Set)o;
            return new HashSet(strings);
        }
        return o;
    }

    public BooleanSerializer getBooleanSerializer() {
        return this.booleanSerializer;
    }

    public ByteSerializer getByteSerializer() {
        return this.byteSerializer;
    }

    public CharSerializer getCharSerializer() {
        return this.charSerializer;
    }

    public DoubleSerializer getDoubleSerializer() {
        return this.doubleSerializer;
    }

    public FloatSerializer getFloatSerializer() {
        return this.floatSerializer;
    }

    public IntegerSerializer getIntegerSerializer() {
        return this.integerSerializer;
    }

    public LongSerializer getLongSerializer() {
        return this.longSerializer;
    }

    public ShortSerializer getShortSerializer() {
        return this.shortSerializer;
    }

    public StringSerializer getStringSerializer() {
        return this.stringSerializer;
    }

    public StringSetSerializer getStringSetSerializer() {
        return this.stringSetSerializer;
    }

    public PersistableSerializer getPersistableSerializer() {
        return this.persistableSerializer;
    }

    public ByteArraySerializer getByteArraySerializer() {
        return this.byteArraySerializer;
    }
}

