/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.fetch;

import com.ironz.binaryprefs.cache.candidates.CacheCandidateProvider;
import com.ironz.binaryprefs.cache.provider.CacheProvider;
import com.ironz.binaryprefs.fetch.FetchStrategy;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;

public final class LazyFetchStrategy
implements FetchStrategy {
    private final Lock readLock;
    private final TaskExecutor taskExecutor;
    private final CacheCandidateProvider candidateProvider;
    private final CacheProvider cacheProvider;
    private final FileTransaction fileTransaction;
    private final SerializerFactory serializerFactory;

    public LazyFetchStrategy(LockFactory lockFactory, TaskExecutor taskExecutor, CacheCandidateProvider candidateProvider, CacheProvider cacheProvider, FileTransaction fileTransaction, SerializerFactory serializerFactory) {
        this.readLock = lockFactory.getReadLock();
        this.taskExecutor = taskExecutor;
        this.candidateProvider = candidateProvider;
        this.cacheProvider = cacheProvider;
        this.fileTransaction = fileTransaction;
        this.serializerFactory = serializerFactory;
        this.fetchCacheCandidates();
    }

    private void fetchCacheCandidates() {
        this.readLock.lock();
        try {
            for (String name : this.fileTransaction.fetchNames()) {
                this.candidateProvider.put(name);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object getValue(String key, Object defValue) {
        return this.getValueInternal(key, defValue);
    }

    @Override
    public Map<String, Object> getAll() {
        return this.getAllInternal();
    }

    @Override
    public boolean contains(String key) {
        return this.containsInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueInternal(String key, Object defValue) {
        this.readLock.lock();
        try {
            Object o = this.getInternal(key, defValue);
            Object object = this.serializerFactory.redefineMutable(o);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Object getInternal(final String key, Object defValue) {
        Object cached = this.cacheProvider.get(key);
        if (cached != null) {
            return cached;
        }
        Set<String> candidates = this.candidateProvider.keys();
        if (!candidates.contains(key)) {
            return defValue;
        }
        FutureBarrier barrier = this.taskExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return LazyFetchStrategy.this.fetchOneFromDiskLocked(key);
            }
        });
        return barrier.completeBlockingWihResult(defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getAllInternal() {
        this.readLock.lock();
        try {
            Set<String> candidates = this.candidateProvider.keys();
            Set<String> cachedKeys = this.cacheProvider.keys();
            Map<String, Object> allCache = this.cacheProvider.getAll();
            if (cachedKeys.containsAll(candidates)) {
                Map<String, Object> map = Collections.unmodifiableMap(allCache);
                return map;
            }
            Map<String, Object> fetched = this.fetchDeltaTask(candidates, cachedKeys);
            Map<String, Object> merged = this.mergeCache(fetched, allCache);
            Map<String, Object> map = Collections.unmodifiableMap(merged);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, Object> mergeCache(Map<String, Object> fetched, Map<String, Object> allCache) {
        int totalCacheSize = fetched.size() + allCache.size();
        HashMap<String, Object> map = new HashMap<String, Object>(totalCacheSize);
        map.putAll(fetched);
        map.putAll(allCache);
        return map;
    }

    private Map<String, Object> fetchDeltaTask(final Set<String> candidates, final Set<String> cachedKeys) {
        FutureBarrier barrier = this.taskExecutor.submit(new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return LazyFetchStrategy.this.fetchDeltaLocked(candidates, cachedKeys);
            }
        });
        return (Map)barrier.completeBlockingWithResultUnsafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> fetchDeltaLocked(Set<String> candidates, Set<String> cachedKeys) {
        this.fileTransaction.lock();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String candidate : candidates) {
                if (cachedKeys.contains(candidate)) continue;
                Object o = this.fetchOneFromDisk(candidate);
                map.put(candidate, o);
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            this.fileTransaction.unlock();
        }
    }

    private Object fetchOneFromDiskLocked(String key) {
        this.fileTransaction.lock();
        try {
            Object object = this.fetchOneFromDisk(key);
            return object;
        }
        finally {
            this.fileTransaction.unlock();
        }
    }

    private Object fetchOneFromDisk(String key) {
        TransactionElement element = this.fileTransaction.fetchOne(key);
        byte[] bytes = element.getContent();
        Object deserialize = this.serializerFactory.deserialize(key, bytes);
        this.cacheProvider.put(key, deserialize);
        return deserialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsInternal(String key) {
        this.readLock.lock();
        try {
            Set<String> candidates = this.candidateProvider.keys();
            boolean bl = candidates.contains(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

