/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.fetch;

import com.ironz.binaryprefs.cache.candidates.CacheCandidateProvider;
import com.ironz.binaryprefs.cache.provider.CacheProvider;
import com.ironz.binaryprefs.fetch.FetchStrategy;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public final class EagerFetchStrategy
implements FetchStrategy {
    private final Lock readLock;
    private final TaskExecutor taskExecutor;
    private final CacheCandidateProvider candidateProvider;
    private final CacheProvider cacheProvider;
    private final FileTransaction fileTransaction;
    private final SerializerFactory serializerFactory;

    public EagerFetchStrategy(LockFactory lockFactory, TaskExecutor taskExecutor, CacheCandidateProvider candidateProvider, CacheProvider cacheProvider, FileTransaction fileTransaction, SerializerFactory serializerFactory) {
        this.readLock = lockFactory.getReadLock();
        this.taskExecutor = taskExecutor;
        this.candidateProvider = candidateProvider;
        this.cacheProvider = cacheProvider;
        this.fileTransaction = fileTransaction;
        this.serializerFactory = serializerFactory;
        this.fetchCache();
    }

    private void fetchCache() {
        this.readLock.lock();
        try {
            FutureBarrier barrier = this.taskExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    EagerFetchStrategy.this.fetchCacheInternal();
                }
            });
            barrier.completeBlockingUnsafe();
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCacheInternal() {
        this.fileTransaction.lock();
        try {
            if (!this.shouldFetch()) {
                return;
            }
            for (TransactionElement element : this.fileTransaction.fetchAll()) {
                String name = element.getName();
                byte[] bytes = element.getContent();
                Object o = this.serializerFactory.deserialize(name, bytes);
                this.cacheProvider.put(name, o);
                this.candidateProvider.put(name);
            }
        }
        finally {
            this.fileTransaction.unlock();
        }
    }

    private boolean shouldFetch() {
        Set<String> names = this.fileTransaction.fetchNames();
        Set<String> cacheKeys = this.cacheProvider.keys();
        return !cacheKeys.containsAll(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(String key, Object defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                Object object = defValue;
                return object;
            }
            Object object = this.serializerFactory.redefineMutable(o);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAll() {
        this.readLock.lock();
        try {
            Map<String, Object> all = this.cacheProvider.getAll();
            HashMap<String, Object> clone = new HashMap<String, Object>(all.size());
            for (String key : all.keySet()) {
                Object value = all.get(key);
                Object redefinedValue = this.serializerFactory.redefineMutable(value);
                clone.put(key, redefinedValue);
            }
            Map map = Collections.unmodifiableMap(clone);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean contains(String key) {
        this.readLock.lock();
        try {
            boolean bl = this.cacheProvider.contains(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

