/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.BinaryPreferencesEditor;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.events.PreferenceEventBridge;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.util.Bits;
import java.io.Externalizable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class BinaryPreferences
implements Preferences {
    private final FileAdapter fileAdapter;
    private final ExceptionHandler exceptionHandler;
    private final PreferenceEventBridge eventsBridge;
    private final CacheProvider cacheProvider;
    private final Class lock = BinaryPreferences.class;

    public BinaryPreferences(FileAdapter fileAdapter, ExceptionHandler exceptionHandler, PreferenceEventBridge eventsBridge, CacheProvider cacheProvider) {
        this.fileAdapter = fileAdapter;
        this.exceptionHandler = exceptionHandler;
        this.eventsBridge = eventsBridge;
        this.cacheProvider = cacheProvider;
        this.defineCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineCache() {
        Class clazz = this.lock;
        synchronized (clazz) {
            for (String name : this.fileAdapter.names()) {
                try {
                    byte[] bytes = this.fileAdapter.fetch(name);
                    this.cacheProvider.put(name, bytes);
                }
                catch (Exception e) {
                    this.exceptionHandler.handle(e, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getAllInternal();
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, "getAll method");
                return new HashMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getStringInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValues) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getStringSetInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValues;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getIntInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getLongInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getFloatInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getBooleanInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Externalizable> T getObject(Class<T> clazz, String key, T defValue) {
        Class clazz2 = this.lock;
        synchronized (clazz2) {
            try {
                return this.getObjectInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Class clazz = this.lock;
        synchronized (clazz) {
            return this.containsInternal(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor edit() {
        Class clazz = this.lock;
        synchronized (clazz) {
            return new BinaryPreferencesEditor(this, this.fileAdapter, this.exceptionHandler, this.eventsBridge, this.cacheProvider, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.eventsBridge.registerOnSharedPreferenceChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.eventsBridge.unregisterOnSharedPreferenceChangeListener(listener);
        }
    }

    private Map<String, ?> getAllInternal() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.cacheProvider.keys()) {
            byte[] bytes = this.cacheProvider.get(key);
            map.put(key, Bits.tryDeserializeByFlag(bytes));
        }
        return map;
    }

    private String getStringInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.stringFromBytesWithFlag(bytes);
    }

    private Set<String> getStringSetInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.stringSetFromBytesWithFlag(bytes);
    }

    private int getIntInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.intFromBytesWithFlag(bytes);
    }

    private long getLongInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.longFromBytesWithFlag(bytes);
    }

    private float getFloatInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.floatFromBytesWithFlag(bytes);
    }

    private boolean getBooleanInternal(String key) {
        byte[] bytes = this.cacheProvider.get(key);
        return Bits.booleanFromBytesWithFlag(bytes);
    }

    private <T extends Externalizable> T getObjectInternal(String key) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private boolean containsInternal(String key) {
        return this.cacheProvider.contains(key);
    }
}

