package com.ironz.binaryprefs.dump;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.ironz.binaryprefs.BinaryPreferences;

import java.util.HashMap;
import java.util.Map;

public final class DumpReceiver extends BroadcastReceiver {

    private static final String PREF_NAME = "pref_name";
    private static final String PREF_KEY = "pref_key";

    private static final Map<String, BinaryPreferences> BINARY_PREFERENCES_HASH_MAP = new HashMap<>();

    @Override
    public void onReceive(Context context, Intent intent) {

        String prefName = intent.getStringExtra(PREF_NAME);

        if (!BINARY_PREFERENCES_HASH_MAP.containsKey(prefName)) {
            Log.e(DumpReceiver.class.getName(), String.format("Cannot find '%s' preference for dumping!", prefName));
        }

        BinaryPreferences preferences = BINARY_PREFERENCES_HASH_MAP.get(prefName);
        Map<String, ?> all = preferences.getAll();

        if (intent.hasExtra(PREF_KEY)) {
            String key = intent.getStringExtra(PREF_KEY);
            Log.d(DumpReceiver.class.getName(), key + ": " + all.get(key) + "\n");
            return;
        }

        for (String key : all.keySet()) {
            Object o = all.get(key);
            Log.d(DumpReceiver.class.getName(), key + ": " + o + "\n");
        }
    }

    @SuppressWarnings("unused")
    public static void appendPreference(String name, BinaryPreferences preferences) {
        BINARY_PREFERENCES_HASH_MAP.put(name, preferences);
    }
}