/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.util;

import java.util.HashSet;
import java.util.Set;

public class Bits {
    static final byte FLAG_STRING_SET = -10;
    static final byte FLAG_STRING = -20;
    static final byte FLAG_INT = -30;
    static final byte FLAG_LONG = -40;
    static final byte FLAG_FLOAT = -50;
    static final byte FLAG_BOOLEAN = -60;
    private static final int INITIAL_INTEGER_LENGTH = 5;
    private static final int NULL_STRING_SIZE = -1;

    private Bits() {
    }

    public static byte[] stringSetToBytes(Set<String> set) {
        byte[][] bytes = new byte[set.size()][];
        int i = 0;
        int totalArraySize = 1;
        for (String s : set) {
            byte[] stringBytes = s == null ? new byte[]{} : s.getBytes();
            byte[] stringSizeBytes = s == null ? Bits.intToBytes(-1) : Bits.intToBytes(stringBytes.length);
            byte[] merged = new byte[stringBytes.length + stringSizeBytes.length];
            System.arraycopy(stringSizeBytes, 0, merged, 0, stringSizeBytes.length);
            System.arraycopy(stringBytes, 0, merged, stringSizeBytes.length, stringBytes.length);
            bytes[i] = merged;
            totalArraySize += merged.length;
            ++i;
        }
        byte[] totalArray = new byte[totalArraySize];
        totalArray[0] = -10;
        int offset = 1;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, totalArray, offset, b.length);
            offset += b.length;
        }
        return totalArray;
    }

    public static Set<String> stringSetFromBytes(byte[] bytes) {
        byte flag = bytes[0];
        if (flag != -10) {
            throw new ClassCastException(String.format("Set<String> cannot be deserialized in '%s' flag type", flag));
        }
        if (bytes.length == 1) {
            return new HashSet<String>(0);
        }
        HashSet<String> set = new HashSet<String>();
        int i = 1;
        while (i < bytes.length) {
            byte[] stringSizeBytes = new byte[]{bytes[i], bytes[i + 1], bytes[i + 2], bytes[i + 3], bytes[i + 4]};
            int stringSize = Bits.intFromBytes(stringSizeBytes);
            if (stringSize == -1) {
                set.add(null);
                i += 5;
                continue;
            }
            byte[] stringBytes = new byte[stringSize];
            for (int k = 0; k < stringBytes.length; ++k) {
                int offset = i + k + 5;
                stringBytes[k] = bytes[offset];
            }
            set.add(new String(stringBytes));
            i += 5 + stringSize;
        }
        return set;
    }

    public static byte[] stringToBytes(String s) {
        byte[] stringBytes = s.getBytes();
        int flagSize = 1;
        byte[] b = new byte[stringBytes.length + flagSize];
        b[0] = -20;
        System.arraycopy(stringBytes, 0, b, flagSize, stringBytes.length);
        return b;
    }

    public static String stringFromBytes(byte[] b) {
        byte flag = b[0];
        if (flag != -20) {
            throw new ClassCastException(String.format("String cannot be deserialized in '%s' flag type", flag));
        }
        int lengthWithoutFlag = b.length - 1;
        return new String(b, 1, lengthWithoutFlag);
    }

    public static byte[] intToBytes(int value) {
        return new byte[]{-30, (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int intFromBytes(byte[] b) {
        int i = 255;
        byte flag = b[0];
        if (flag != -30) {
            throw new ClassCastException(String.format("int cannot be deserialized in '%s' flag type", flag));
        }
        return (b[4] & i) + ((b[3] & i) << 8) + ((b[2] & i) << 16) + (b[1] << 24);
    }

    public static byte[] floatToBytes(float value) {
        int i = Float.floatToIntBits(value);
        return new byte[]{-50, (byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)value};
    }

    public static float floatFromBytes(byte[] b) {
        int i = 255;
        byte flag = b[0];
        if (flag != -50) {
            throw new ClassCastException(String.format("float cannot be deserialized in '%s' flag type", flag));
        }
        int value = (b[4] & i) + ((b[3] & i) << 8) + ((b[2] & i) << 16) + (b[1] << 24);
        return Float.intBitsToFloat(value);
    }

    public static byte[] longToBytes(long value) {
        return new byte[]{-40, (byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static long longFromBytes(byte[] b) {
        long l = 255L;
        byte flag = b[0];
        if (flag != -40) {
            throw new ClassCastException(String.format("long cannot be deserialized in '%s' flag type", flag));
        }
        return ((long)b[8] & l) + (((long)b[7] & l) << 8) + (((long)b[6] & l) << 16) + (((long)b[5] & l) << 24) + (((long)b[4] & l) << 32) + (((long)b[3] & l) << 40) + (((long)b[2] & l) << 48) + ((long)b[1] << 56);
    }

    public static byte[] booleanToBytes(boolean value) {
        return new byte[]{-60, (byte)(value ? 1 : 0)};
    }

    public static boolean booleanFromBytes(byte[] b) {
        byte flag = b[0];
        if (flag != -60) {
            throw new ClassCastException(String.format("boolean cannot be deserialized in '%s' flag type", flag));
        }
        return b[1] != 0;
    }
}

