/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yalantis.ucrop.OkHttpClientStore;
import com.yalantis.ucrop.callback.BitmapLoadCallback;
import com.yalantis.ucrop.model.ExifInfo;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

public class BitmapLoadTask
extends AsyncTask<Void, Void, BitmapWorkerResult> {
    private static final String TAG = "BitmapWorkerTask";
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    private final WeakReference<Context> mContext;
    private Uri mInputUri;
    private Uri mOutputUri;
    private final int mRequiredWidth;
    private final int mRequiredHeight;
    private final BitmapLoadCallback mBitmapLoadCallback;

    public BitmapLoadTask(@NonNull Context context, @NonNull Uri inputUri, @Nullable Uri outputUri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
        this.mContext = new WeakReference<Context>(context);
        this.mInputUri = inputUri;
        this.mOutputUri = outputUri;
        this.mRequiredWidth = requiredWidth;
        this.mRequiredHeight = requiredHeight;
        this.mBitmapLoadCallback = loadCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    protected BitmapWorkerResult doInBackground(Void ... params) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return new BitmapWorkerResult(new NullPointerException("context is null"));
        }
        if (this.mInputUri == null) {
            return new BitmapWorkerResult(new NullPointerException("Input Uri cannot be null"));
        }
        try {
            this.processInputUri();
        }
        catch (IOException | NullPointerException e) {
            return new BitmapWorkerResult(e);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = BitmapLoadUtils.calculateInSampleSize(options, this.mRequiredWidth, this.mRequiredHeight);
        options.inJustDecodeBounds = false;
        Bitmap decodeSampledBitmap = null;
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            try {
                InputStream stream = context.getContentResolver().openInputStream(this.mInputUri);
                try {
                    decodeSampledBitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                    if (options.outWidth == -1 || options.outHeight == -1) {
                        BitmapWorkerResult bitmapWorkerResult = new BitmapWorkerResult(new IllegalArgumentException("Bounds for bitmap could not be retrieved from the Uri: [" + this.mInputUri + "]"));
                        return bitmapWorkerResult;
                    }
                }
                finally {
                    BitmapLoadUtils.close(stream);
                }
                if (this.checkSize(decodeSampledBitmap, options)) continue;
                decodeAttemptSuccess = true;
            }
            catch (OutOfMemoryError error) {
                Log.e((String)TAG, (String)"doInBackground: BitmapFactory.decodeFileDescriptor: ", (Throwable)error);
                options.inSampleSize *= 2;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"doInBackground: ImageDecoder.createSource: ", (Throwable)e);
                return new BitmapWorkerResult(new IllegalArgumentException("Bitmap could not be decoded from the Uri: [" + this.mInputUri + "]", e));
            }
        }
        if (decodeSampledBitmap == null) {
            return new BitmapWorkerResult(new IllegalArgumentException("Bitmap could not be decoded from the Uri: [" + this.mInputUri + "]"));
        }
        int exifOrientation = BitmapLoadUtils.getExifOrientation(context, this.mInputUri);
        int exifDegrees = BitmapLoadUtils.exifToDegrees(exifOrientation);
        int exifTranslation = BitmapLoadUtils.exifToTranslation(exifOrientation);
        ExifInfo exifInfo = new ExifInfo(exifOrientation, exifDegrees, exifTranslation);
        Matrix matrix = new Matrix();
        if (exifDegrees != 0) {
            matrix.preRotate((float)exifDegrees);
        }
        if (exifTranslation != 1) {
            matrix.postScale((float)exifTranslation, 1.0f);
        }
        if (matrix.isIdentity()) return new BitmapWorkerResult(decodeSampledBitmap, exifInfo);
        return new BitmapWorkerResult(BitmapLoadUtils.transformBitmap(decodeSampledBitmap, matrix), exifInfo);
    }

    private void processInputUri() throws NullPointerException, IOException {
        Log.d((String)TAG, (String)("Uri scheme: " + this.mInputUri.getScheme()));
        if (this.isDownloadUri(this.mInputUri)) {
            try {
                this.downloadFile(this.mInputUri, this.mOutputUri);
            }
            catch (IOException | NullPointerException e) {
                Log.e((String)TAG, (String)"Downloading failed", (Throwable)e);
                throw e;
            }
        } else if (this.isContentUri(this.mInputUri)) {
            try {
                this.copyFile(this.mInputUri, this.mOutputUri);
            }
            catch (IOException | NullPointerException e) {
                Log.e((String)TAG, (String)"Copying failed", (Throwable)e);
                throw e;
            }
        } else if (!this.isFileUri(this.mInputUri)) {
            String inputUriScheme = this.mInputUri.getScheme();
            Log.e((String)TAG, (String)("Invalid Uri scheme " + inputUriScheme));
            throw new IllegalArgumentException("Invalid Uri scheme" + inputUriScheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(@NonNull Uri inputUri, @Nullable Uri outputUri) throws NullPointerException, IOException {
        Log.d((String)TAG, (String)"copyFile");
        if (outputUri == null) {
            throw new NullPointerException("Output Uri is null - cannot copy image");
        }
        Context context = (Context)this.mContext.get();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int length;
            inputStream = context.getContentResolver().openInputStream(inputUri);
            if (inputStream == null) {
                throw new NullPointerException("InputStream for given input Uri is null");
            }
            outputStream = this.isContentUri(outputUri) ? context.getContentResolver().openOutputStream(outputUri) : new FileOutputStream(new File(outputUri.getPath()));
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            BitmapLoadUtils.close(outputStream);
            BitmapLoadUtils.close(inputStream);
            this.mInputUri = this.mOutputUri;
            throw throwable;
        }
        BitmapLoadUtils.close(outputStream);
        BitmapLoadUtils.close(inputStream);
        this.mInputUri = this.mOutputUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(@NonNull Uri inputUri, @Nullable Uri outputUri) throws NullPointerException, IOException {
        Log.d((String)TAG, (String)"downloadFile");
        if (outputUri == null) {
            throw new NullPointerException("Output Uri is null - cannot download image");
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        OkHttpClient client = OkHttpClientStore.INSTANCE.getClient();
        BufferedSource source = null;
        Sink sink = null;
        Response response = null;
        try {
            Request request = new Request.Builder().url(inputUri.toString()).build();
            response = client.newCall(request).execute();
            source = response.body().source();
            OutputStream outputStream = this.isContentUri(this.mOutputUri) ? context.getContentResolver().openOutputStream(outputUri) : new FileOutputStream(new File(outputUri.getPath()));
            if (outputStream == null) {
                throw new NullPointerException("OutputStream for given output Uri is null");
            }
            sink = Okio.sink((OutputStream)outputStream);
            source.readAll(sink);
        }
        catch (Throwable throwable) {
            BitmapLoadUtils.close(source);
            BitmapLoadUtils.close(sink);
            if (response != null) {
                BitmapLoadUtils.close((Closeable)response.body());
            }
            client.dispatcher().cancelAll();
            this.mInputUri = this.mOutputUri;
            throw throwable;
        }
        BitmapLoadUtils.close((Closeable)source);
        BitmapLoadUtils.close((Closeable)sink);
        if (response != null) {
            BitmapLoadUtils.close((Closeable)response.body());
        }
        client.dispatcher().cancelAll();
        this.mInputUri = this.mOutputUri;
    }

    protected void onPostExecute(@NonNull BitmapWorkerResult result) {
        if (result.mBitmapWorkerException == null) {
            this.mBitmapLoadCallback.onBitmapLoaded(result.mBitmapResult, result.mExifInfo, this.mInputUri, this.mOutputUri);
        } else {
            this.mBitmapLoadCallback.onFailure(result.mBitmapWorkerException);
        }
    }

    private boolean checkSize(Bitmap bitmap, BitmapFactory.Options options) {
        int bitmapSize;
        int n = bitmapSize = bitmap != null ? bitmap.getByteCount() : 0;
        if (bitmapSize > 0x6400000) {
            options.inSampleSize *= 2;
            return true;
        }
        return false;
    }

    private boolean isDownloadUri(Uri uri) {
        String schema = uri.getScheme();
        return schema.equals("http") || schema.equals("https");
    }

    private boolean isContentUri(Uri uri) {
        String schema = uri.getScheme();
        return schema.equals("content");
    }

    private boolean isFileUri(Uri uri) {
        String schema = uri.getScheme();
        return schema.equals("file");
    }

    public static class BitmapWorkerResult {
        Bitmap mBitmapResult;
        ExifInfo mExifInfo;
        Exception mBitmapWorkerException;

        public BitmapWorkerResult(@NonNull Bitmap bitmapResult, @NonNull ExifInfo exifInfo) {
            this.mBitmapResult = bitmapResult;
            this.mExifInfo = exifInfo;
        }

        public BitmapWorkerResult(@NonNull Exception bitmapWorkerException) {
            this.mBitmapWorkerException = bitmapWorkerException;
        }
    }
}

