/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.typeface;

import android.text.Spannable;
import android.text.style.CharacterStyle;
import android.text.style.TypefaceSpan;
import android.widget.TextView;
import com.xycoding.richtext.typeface.ClickSpan;

public class WordClickSpan
extends ClickSpan {
    private OnWordClickListener mClickListener;

    public WordClickSpan(int normalTextColor, int pressedTextColor, int pressedBackgroundColor, OnWordClickListener listener) {
        super(normalTextColor, pressedTextColor, pressedBackgroundColor, null);
        this.mClickListener = listener;
    }

    @Override
    public void onClick(TextView textView, String pressedText, float rawX, float rawY, Spannable spannable, int start, int end) {
        this.mCachedSpannable = spannable;
        this.mClickStart = start;
        this.mClickEnd = end;
        this.mCachedStyles = (CharacterStyle[])spannable.getSpans(start, end, CharacterStyle.class);
        if (this.mCachedStyles != null) {
            for (CharacterStyle style : this.mCachedStyles) {
                if (style instanceof TypefaceSpan) continue;
                spannable.removeSpan((Object)style);
            }
        }
        spannable.setSpan((Object)this.mBackgroundColorSpan, start, end, 33);
        spannable.setSpan((Object)this.mForegroundColorSpan, start, end, 33);
        if (this.mClickListener != null) {
            this.mClickListener.onClick(this, textView, pressedText, rawX, rawY);
        }
    }

    @Override
    public CharacterStyle getStyleSpan() {
        return new WordClickSpan(this.mNormalTextColor, this.mPressedTextColor, this.mPressedBackgroundColor, this.mClickListener);
    }

    public static interface OnWordClickListener {
        public void onClick(WordClickSpan var1, TextView var2, CharSequence var3, float var4, float var5);
    }
}

