/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.typeface;

import android.text.Spannable;
import android.text.style.CharacterStyle;
import android.widget.TextView;
import com.xycoding.richtext.typeface.ClickSpan;

public class LinkClickSpan
extends ClickSpan {
    private OnLinkClickListener mLinkClickListener;
    private String mUrl;

    public LinkClickSpan(int normalTextColor, int pressedTextColor, int pressedBackgroundColor, OnLinkClickListener listener) {
        super(normalTextColor, pressedTextColor, pressedBackgroundColor, null);
        this.mLinkClickListener = listener;
    }

    @Override
    public CharacterStyle getStyleSpan() {
        LinkClickSpan span = new LinkClickSpan(this.mNormalTextColor, this.mPressedTextColor, this.mPressedBackgroundColor, this.mLinkClickListener);
        span.setLinkUrl(this.mUrl);
        return span;
    }

    @Override
    public void onClick(TextView textView, String pressedText, float rawX, float rawY, Spannable spannable, int start, int end) {
        super.onClick(textView, pressedText, rawX, rawY, spannable, start, end);
        if (this.mLinkClickListener != null) {
            this.mLinkClickListener.onClick(textView, this.mUrl);
        }
    }

    public void setLinkUrl(String url) {
        this.mUrl = url;
    }

    public static interface OnLinkClickListener {
        public void onClick(TextView var1, String var2);
    }
}

